from sandbox import sdk2
from sandbox.projects.adfox.qa.resource_types import AdfoxShmAdfoxSpec

RESOURCE_URL_TEMPLATE = "https://proxy.sandbox.yandex-team.ru/{0}"

"""
Converts spec_file to spec_json so it can be used in testenv via parent_test_ctx
"""


class AdfoxServerSpecFileToJson(sdk2.Task):
    name = "ADFOX_SERVER_SPEC_FILE_TO_JSON"

    class Parameters(sdk2.Parameters):
        spec_file = sdk2.parameters.Resource("spec_file", resource_type=AdfoxShmAdfoxSpec, required=True)

        # for visualization
        with sdk2.parameters.Output:
            spec_json = sdk2.parameters.JSON("spec_json")

    class Context(sdk2.Context):
        spec_json = dict()

    def on_execute(self):
        import requests

        resource_url = RESOURCE_URL_TEMPLATE.format(self.Parameters.spec_file.id)
        spec_json = requests.get(resource_url).json()
        self.Parameters.spec_json = spec_json
        self.Context.spec_json = spec_json
