import logging

from sandbox import sdk2


def build_options(prefix=None, **options):
    def prefixed_options():
        if prefix:
            return {prefix + k: v for k, v in options.items()}
        else:
            return options

    parameters_dictionary = prefixed_options()
    parameters_dictionary['__names__'] = tuple(k for k in parameters_dictionary.keys())
    parameters_dictionary['__options_prefix__'] = prefix

    class PrefixAttributes(sdk2.Task.Parameters.__class__):
        def __getattribute__(self, attr):
            if self.__getattr__('__options_prefix__'):
                attr = self.__getattr__('__options_prefix__') + attr
            return object.__getattribute__(self, attr)

    return PrefixAttributes('Parameters', (sdk2.Task.Parameters,), parameters_dictionary)


class AdfoxServerTestTask(sdk2.Task):
    name = 'ADFOX_SERVER_TEST_TASK'

    build_options(
        prefix='adfox.prefix.',
        executable=sdk2.parameters.String('executable'),
        second_executable=sdk2.parameters.String('second_executable')
    )

    def on_execute(self):
        logging.info(self.Parameters.executable)
        logging.info(self.Parameters.second_executable)
