from sandbox.projects.adfox.qa.utils.secrets import get_yav_secret
from sandbox.projects.adfox.qa.utils.constants import DB_RO_PASSWORD


def get_migration_version(migration_date, database):
    import pymysql

    connection = pymysql.connect(host='db-slave.adfox.ru', port=3306, user='ro',
                                 password=get_yav_secret(DB_RO_PASSWORD)['password'], charset='cp1251')
    with connection.cursor() as cursor:
        cursor.execute("""
                SELECT version
                FROM {0}.phinxlog
                WHERE end_time < '{1}'
                ORDER BY end_time DESC, version DESC LIMIT 1
            """.format(database, migration_date.strftime('%Y-%m-%d %H:%M:%S')))
        records = cursor.fetchall()
    connection.close()
    return str(records[0][0])


def disable_database_strict_mode():
    import pymysql

    connection = pymysql.connect(host='localhost', port=3306, user='adfox',
                                 password='', charset='cp1251')
    with connection.cursor() as cursor:
        cursor.execute("SET GLOBAL sql_mode = 'NO_ENGINE_SUBSTITUTION';")
    connection.commit()
    connection.close()
