import logging
import time
from functools import wraps


def retry(exc_cls=Exception, tries=1, delay=1):
    def deco_retry(func):
        @wraps(func)
        def func_retry(*args, **kwargs):
            func_tries = tries
            while func_tries > 0:
                try:
                    return func(*args, **kwargs)
                except exc_cls as err:
                    message = 'function: {} - error: {} retry in {} seconds'.format(func.func_name, str(err), delay)
                    func_tries -= 1
                    logging.error(message)
                    time.sleep(delay)

        return func_retry

    return deco_retry
