from sandbox.projects.adfox.qa.utils import constants
from sandbox.projects.adfox.qa.utils.secrets import get_yav_secret


def get_connection(log=False):
    """
    Can be used to get connection to PGaaS
    :param log: should connection log queries?
    :return:
    """
    import logging
    import psycopg2
    from psycopg2.extras import LoggingConnection

    pgaas_details = get_yav_secret(constants.YAV_ROBOT_QA_ADFOX_SHM_PGAAS)
    connection_args = dict(
        host=pgaas_details['HOSTS'], port=int(pgaas_details['PORT']),
        dbname=pgaas_details['DB'], user=pgaas_details['USER'],
        password=pgaas_details['PASSWORD']
    )
    if log:
        connection_args['connection_factory'] = LoggingConnection
    connection = psycopg2.connect(**connection_args)
    if log:
        logger = logging.getLogger('pgaas_connection')
        logger.setLevel(logging.DEBUG)
        connection.initialize(logger)

    return connection
