from sandbox import sdk2

from sandbox.projects.adfox.qa.utils.constants import SANDBOX_VAULT_OWNER, SB_ROBOT_QA_ADFOX_YAV_OAUTH_TOKEN


def get_sb_secret(secret_alias, owner=SANDBOX_VAULT_OWNER):
    """
    Retrieves secret from Sandbox vault
    :param secret_alias: alias of the secret to retrieve
    :param owner: owner of the secret
    :return:
    """
    return sdk2.Vault.data(owner, secret_alias)


def get_yav_secret(secret_id, oauth_token=None):
    """
    Retrieves secret from YAV via HTTP
    :param oauth_token: oauth token to YAV for HTTP requests
    :param secret_id: id of the secret to retrieve
    :return:
    """
    # if oauth_token is None - try to get SB_ROBOT_QA_ADFOX_YAV_OAUTH_TOKEN and use it
    if not oauth_token:
        oauth_token = get_sb_secret(SB_ROBOT_QA_ADFOX_YAV_OAUTH_TOKEN)

    import requests

    api_url = 'https://vault-api.passport.yandex.net/1/versions/{}'.format(secret_id)
    secret = requests.get(api_url, headers={'Authorization': 'OAuth {}'.format(oauth_token)},
                          verify=False).json()
    if secret['status'] != 'ok':
        raise Exception('Error on getting YAV secret data: {0}'.format(secret['message']))

    secret_data = {el['key']: el['value'] for el in secret['version']['value']}
    return secret_data
