# -*- coding: utf-8 -*-

import difflib
import json

from sandbox import sdk2

from sandbox.projects.adfox.release.AdfoxServerBuildConfiguration import AdfoxServerBuildConfiguration
from sandbox.projects.adfox.resource_types import AdfoxConfigurationRaw


class AdfoxServerCompareConfiguration(sdk2.Task):
    name = "ADFOX_SERVER_COMPARE_CONFIGURATION"

    class Parameters(sdk2.Task.Parameters):
        first_task = sdk2.parameters.Task("first task", task_type=AdfoxServerBuildConfiguration, required=True)
        second_task = sdk2.parameters.Task("second task", task_type=AdfoxServerBuildConfiguration, required=True)

    class Context(sdk2.Task.Context):
        has_diff = False
        testenv_database = None

    def on_execute(self):
        first_task_resource = sdk2.Resource.find(
            resource_type=AdfoxConfigurationRaw,
            task_id=self.Parameters.first_task.id
        ).first()
        with open(str(sdk2.ResourceData(first_task_resource).path)) as input_file:
            first_task_json = json.load(input_file)

        second_task_resource = sdk2.Resource.find(
            resource_type=AdfoxConfigurationRaw,
            task_id=self.Parameters.second_task.id
        ).first()
        with open(str(sdk2.ResourceData(second_task_resource).path)) as input_file:
            second_task_json = json.load(input_file)

        calculated_diff = list(difflib.unified_diff(
            [json.dumps(el, sort_keys=True) for el in first_task_json],
            [json.dumps(el, sort_keys=True) for el in second_task_json],
            fromfile="first_task", tofile="second_task", lineterm="")
        )

        def get_line(text, color):
            return "<span style=\"font-family:'Courier';color:{0}\">{1}</span></br>".format(color, text)

        out_text = ["<p>"]
        if calculated_diff:
            out_text.append("<h1 style=\"font-family:'Courier';color:red\">DIFF</h1></br>")
            self.Context.has_diff = True
            for l in calculated_diff:
                if l.startswith("-"):
                    out_text.append(get_line(l, color="red"))
                elif l.startswith("+"):
                    out_text.append(get_line(l, color="green"))
                else:
                    out_text.append(get_line(l, color="black"))
        else:
            out_text.append("<h1 style=\"font-family:'Courier';color:green\">NO DIFF</h1>")
            self.Context.has_diff = False
        out_text.append("</p>")
        self.set_info("".join(out_text), do_escape=False)
