import urlparse

import requests
from sandbox import sdk2

from sandbox.projects.common.yabs.server.util import send_startrek_report
from sandbox.projects.yabs.release.common import BaseReleaseTask
from sandbox.projects.yabs.qa.utils.general import startrek_hyperlink
from sandbox.common.utils import get_task_link

TESTENV_API_BASE_URL = 'https://testenv.yandex-team.ru/handlers/'
TESTENV_API_TEST_RESULTS = urlparse.urljoin(TESTENV_API_BASE_URL, 'grids/testResults')
HTTP_TIMEOUT = 60


def get_revision_link(revision):
    return startrek_hyperlink('https://a.yandex-team.ru/commit/{0}'.format(revision), str(revision))


class AdfoxServerGetCheckTaskStatus(BaseReleaseTask):
    """
    Gets TE check test status on selected revision
    """
    name = 'ADFOX_SERVER_GET_CHECK_TASK_STATUS'

    _session = None

    @property
    def session(self):
        if not self._session:
            self._session = requests.Session()
            self._session.verify = '/etc/ssl/certs/YandexInternalRootCA.pem'
        return self._session

    class Parameters(BaseReleaseTask.Parameters):
        test_name = sdk2.parameters.String('Testenv test name')
        link = sdk2.parameters.String('Additional link for ST comment')

    def send_report(self, report):
        st_token = sdk2.Vault.data(self.Parameters.st_vault_name)
        release_ticket = self.get_release_ticket()
        if self.Parameters.link:
            report = '{0} Learn more {1}.'.format(report, startrek_hyperlink(self.Parameters.link, 'here'))
        send_startrek_report(st_token, release_ticket, report)

    def on_execute(self):

        tests = self.session.get(
            TESTENV_API_TEST_RESULTS,
            params={
                'database': self.Parameters.database_name,
                'test_name': self.Parameters.test_name,
                'hide_filtered': 'true',
                'limit': 1000,
                'start': 0
            },
            timeout=HTTP_TIMEOUT).json()['rows']

        final_revision = self.get_final_revision()
        found_test = None
        for test in tests:
            if test['revision'] == final_revision:
                found_test = test
                break
            elif test['revision'] < final_revision:
                return self.send_report('Test {test} was **!!(red)not launched!!** on {revision}!'.format(
                    test=self.Parameters.test_name,
                    revision=get_revision_link(final_revision)
                ))

        if found_test and found_test['status'] != 'OK':
            return self.send_report('Test {test} is in **!!(red){status}!!** status on {revision}, task {task}!'.format(
                test=self.Parameters.test_name,
                status=found_test['status'],
                revision=get_revision_link(final_revision),
                task=startrek_hyperlink(get_task_link(found_test['task_id']), str(found_test['task_id']))
            ))

        return self.send_report('Test {test} is in **!!(green){status}!!** status on {revision}, task {task}!'.format(
            test=self.Parameters.test_name,
            status=found_test['status'],
            revision=get_revision_link(final_revision),
            task=startrek_hyperlink(get_task_link(found_test['task_id']), str(found_test['task_id']))
        ))
