--Aud.BuildSegmentsDMP
use hahn;

-- YT Parameters
PRAGMA yt.Pool = 'adfox-stat';
PRAGMA yt.Owners = 'helium,r4start,suetin,void2';

insert into `{TARGET_TABLE}`
select 
    "{REPORT_DATE}" as `date`,
    events.owner_id as owner_id,
    events.site_id as site_id,
    events.section_id as section_id,
    events.place_id as place_id,
    profiles.dmp_id as dmp_id,
    profiles.segment as segment_id,
    SUM(events.RequestsCount) as requests_count
from `{EVENTS_SOURCE_TABLE}` as events
    join (
            select
                UniqID as UniqID,
                dmp_id as dmp_id,
                segment as segment
            from
                (
                    select
                        UniqID,
                        dmp.dmp_id as dmp_id,
                        YQL::Unwrap(dmp.segments) as segments
                    from `{PROFILE_SOURCE_TABLE}`
                    FLATTEN BY Dmps as dmp
                ) as dmp_profiles
            FLATTEN BY segments as segment
         ) as profiles
        on events.ya_uid = cast(profiles.UniqID as Uint64)
    group by events.owner_id, events.site_id, events.section_id, events.place_id, profiles.dmp_id, profiles.segment
    order by owner_id, site_id, section_id, place_id, dmp_id, segment_id
