-- Aud.BuildSegmentsYaAud
use hahn;

-- YT Parameters
PRAGMA yt.Pool = 'adfox-stat';
PRAGMA yt.Owners = 'helium,r4start,suetin,void2';

$ya_min_segment = 2000000000;
$ya_max_segment = 3000000000;
$segments = (
    select 
        cast(UniqID as Uint64) as UniqID,
        Segments as Segment
    from `{PROFILE_SOURCE_TABLE}`
        FLATTEN BY Segments
    where Segments between $ya_min_segment and $ya_max_segment
    );

insert into `{TARGET_TABLE}`
select
    "{REPORT_DATE}" as `date`,
    events.owner_id as owner_id,
    events.site_id as site_id,
    events.section_id as section_id,
    events.place_id as place_id,
    profiles.Segment as segment_id,
    SUM(events.RequestsCount) as requests_count
from `{EVENTS_SOURCE_TABLE}` as events
    join (select UniqID, Segment from $segments) as profiles
        on events.ya_uid = profiles.UniqID
group by events.owner_id, events.site_id, events.section_id, events.place_id, profiles.Segment
order by owner_id, site_id, section_id, place_id, segment_id
