use hahn;

-- YT Parameters
PRAGMA yt.Pool = 'adfox-stat';
PRAGMA yt.Owners = 'helium,r4start,suetin,void2';
PRAGMA yt.MaxRowWeight = '134217728';

-- https://wiki.yandex-team.ru/bigb/udfs/
PRAGMA File('bigb.so', 'https://proxy.sandbox.yandex-team.ru/last/BIGB_UDF?attrs={{"released":"stable"}}');
PRAGMA udf('bigb.so');

-- Aud.RefineProfiles
-- Вытаскивает из профиля пользователя интересующую нас информацию о сегментации

-- Преобразовать message Dmp в упрощенную структуру о ДМП: [dmp_id, [segment_id]]
$ConvertDmpItem = YQL::@@(lambda '(dmp) (block '(
    (return (AsStruct 
        '('dmp_id (Member dmp 'dmp_id))
        '('segments (Member dmp 'segments))
    ))
)))@@;

-- Возвращает пустой список структур [dmp_id, [segment_id]]
$EmptyDmpList = YQL::List(YQL::ListType(YQL::StructType(
    (AsAtom('dmp_id'), YQL::DataType(AsAtom('Uint32'))),
    (AsAtom('segments'), YQL::ListType(YQL::DataType(AsAtom('Uint32'))))
)));

$IsNormalDmp = ($dmp) -> {{
    return YQL::Exists($dmp.dmp_id) and YQL::Exists($dmp.segments) and (ListLength($dmp.segments) > 0);
}};

-- Пустой список сегментов Я.Аудиторий
$EmptySegmentsList = YQL::List(YQL::ListType(
    YQL::DataType(AsAtom('Uint32'))
));

-- Сегменты потихоньку переезжают в 557й кеворд (ADFOX-10994)
$Is235Keyword = ($item) -> {{
    return (($item.keyword_id == 235) or ($item.keyword_id == 557)) and (YQL::Exists($item.uint_values) and (ListLength($item.uint_values) > 0));
}};

$Convert235Item = YQL::@@(lambda '(item) (block '(
    (let values (Member item 'uint_values))
    (let dict (ToIndexDict values))
    (return (Unwrap (Lookup dict (Uint32 '0))))
)))@@;

$Get235Items = ListMap(ListFilter(src.ProfileDump.items, $Is235Keyword), $Convert235Item);

insert into `{TARGET_TABLE}`
SELECT
    CAST(lg.UniqID AS Uint64) AS UniqID,
    YQL::If(YQL::Exists(lg.ProfileDump.dmps), ListMap(ListFilter(lg.ProfileDump.dmps, $IsNormalDmp), $ConvertDmpItem), $EmptyDmpList) as Dmps,
    YQL::If(YQL::Exists(lg.ProfileDump.items), ListMap(ListFilter(lg.ProfileDump.items, $Is235Keyword), $Convert235Item), $EmptySegmentsList) as Segments
FROM
(
    SELECT DISTINCT ya_uid
    FROM `{EVENTS_TABLE}`
    WHERE ya_uid != 0
) as evnts
LEFT JOIN ANY
(
    SELECT
        UniqID,
        Bigb::ParseProfile(ProfileDump) as ProfileDump
    FROM
        LIKE(`//home/logfeller/logs/beh-profile-hit-log/1h`, "{REPORT_DATE}%")
        TABLESAMPLE SYSTEM(10.0)
    {QUERY_POSTFIX}
) AS lg ON CAST(lg.UniqID AS Uint64) = evnts.ya_uid
{QUERY_POSTFIX}