use hahn;

-- YT Parameters
PRAGMA yt.Pool = 'adfox-stat';
PRAGMA yt.Owners = 'helium,r4start,suetin,void2';

-- Aud.GetEventsRefined
insert into `{TARGET_TABLE}`
select
    owner_id,
    site_id,
    section_id,
    place_id,
    ya_uid,
    count(*) as RequestsCount
from    (
            select 
                (src.owner_id) as owner_id,
                (src.site_id) as site_id,
                (src.section_id) as section_id,
                (src.place_id) as place_id,
                (ya_uid) as ya_uid
            from LIKE(`//logs/adfox-event-log/1d`, "{REPORT_DATE}%")  as src
            where 
                    (src.flag_virtual) = 0
                and (src.load) = 1
                and (src.ignore is null or src.ignore == "")
        ) as src
group by
    owner_id,
    site_id,
    section_id,
    place_id,
    ya_uid
order by
    owner_id,
    site_id,
    section_id,
    place_id,
    ya_uid
{QUERY_POSTFIX}