from sandbox import sdk2

from sandbox.projects.common.build.YaPackage import YaPackageResource

# https://sandbox.yandex-team.ru/admin/groups/ADFOX
CORE_TEAM = ["bahbka", "ADFOX"]
RELEASERS = CORE_TEAM + ['robot-testenv']


class AdfoxZookeeperSamogonPackage(sdk2.Resource):
    """
       samogon package for adfox zookeeper
    """
    releasable = True
    auto_backup = True
    releasers = CORE_TEAM


class AdfoxMatchidSamogonPackage(sdk2.Resource):
    """
       samogon package for adfox matchid
    """
    releasable = True
    auto_backup = True
    releasers = CORE_TEAM


class AdfoxServer(sdk2.Resource):
    """
        amacs debian package (created using Cmake)
    """
    auto_backup = True
    releasable = True
    releasers = RELEASERS


class AdfoxServerYa(sdk2.Resource):
    """
        amacs debian package (created using ya)
    """
    auto_backup = True
    releasable = True
    releasers = RELEASERS


class AdfoxServerYaStrip(sdk2.Resource):
    """
        stripped amacs debian package (created using ya)
    """
    auto_backup = True
    releasable = True
    releasers = RELEASERS


class AdfoxDebinfoPackage(sdk2.Resource):
    """
        debian package with debinfo
    """
    auto_backup = True
    releasable = True
    releasers = RELEASERS


class AdfoxPredictorPackageYa(sdk2.Resource):
    """
        predictor debian package (created using ya)
    """
    auto_backup = True
    releasable = True
    releasers = RELEASERS


class AdfoxPredictorPackage(sdk2.Resource):
    """
        predictor debian package
    """
    auto_backup = True
    releasable = True
    releasers = RELEASERS


class AdfoxServerTestResults(sdk2.Resource):
    auto_backup = False
    releasable = False


class AdfoxServerTestDiffResource(sdk2.Resource):
    auto_backup = False
    releasable = False


class AdfoxServerYaTestResults(sdk2.Resource):
    auto_backup = False
    releasable = False


class AdfoxServerYaTestDiffResource(sdk2.Resource):
    auto_backup = False
    releasable = False


class AdfoxAtlasCacheFile(sdk2.Resource):
    """
        atlas cache binary file
    """
    auto_backup = True  # need backup, can be important
    revision = sdk2.parameters.Integer('revision', required=False)  # bridge revision
    # one of "production", "production.recreated", "qa.functional"
    target = sdk2.parameters.String('Target', required=True)
    # when cache was created
    creation_timestamp = sdk2.parameters.Integer('Creation timestamp', required=False, default=None)
    # hash of atlas lib sources - used in "update_atlas" task to find suitable resource
    sources_hash = sdk2.parameters.String('Sources hash', required=False, default=None)

    # used for tests
    test_name = sdk2.parameters.String('Test name', required=False, default=None)
    # used for switching resources in TE database "adfox-shm"
    testenv_switch_trigger_adfox = sdk2.parameters.String('TE switch trigger', required=False, default=None)


class AdfoxArchivedAtlasCacheFile(sdk2.Resource):
    """
        archived atlas cache binary file
    """
    ttl = 60


class AdfoxXpdServer(YaPackageResource):
    """
        adfox xpd_server binary package
    """
    releasable = True
    releasers = RELEASERS
    calc_md5 = True
    share = True


class AdfoxMatchdBinary(YaPackageResource):
    """
        matchd tar.gz package (created using ya package)
        contains:
        - matchd executable
    """
    auto_backup = True
    releasable = True
    releasers = RELEASERS
    calc_md5 = True
    share = True


class AdfoxBrotifyBinary(YaPackageResource):
    """
        broker notify tar.gz package (created using ya package)
        contains:
        - brotifyd executable
    """
    auto_backup = True
    releasable = True
    releasers = RELEASERS
    calc_md5 = True
    share = True


class AdfoxRtdBinary(YaPackageResource):
    """
        - RTD service executable
    """
    auto_backup = True
    releasable = True
    releasers = RELEASERS
    calc_md5 = True
    share = True


class AdfoxAtlasToDbUploader(YaPackageResource):
    """
        atlas_to_database tar.gz package (created using ya package)
        contains:
        - atlas_to_database
    """
    auto_backup = True
    releasable = True
    releasers = RELEASERS
    calc_md5 = True
    share = True
    testenv_switch_trigger_adfox = sdk2.parameters.String(required=False, default=None)


class AdfoxNginx(YaPackageResource):
    """
        Yandex Nginx 1.14.2
        + vts module
        + json-c module
        See https://a.yandex-team.ru/review/1005608/files/1
    """
    auto_backup = True
    releasable = True
    releasers = RELEASERS
    calc_md5 = True
    share = True


class AdfoxSolomonController(YaPackageResource):
    """
        adfox-solomon-controller package
    """
    auto_backup = True
    releasable = True
    releasers = RELEASERS
    calc_md5 = True
    share = True


class AdfoxUnloadClientLogsVh(YaPackageResource):
    """
        unload_client_logs package
    """
    auto_backup = True
    releasable = True
    releasers = RELEASERS
    calc_md5 = True
    share = True


class AdfoxMatchidDeployPackage(YaPackageResource):
    """
        matchd tar.gz package (created using ya package)
        contains:
        - matchd executable
    """
    auto_backup = True
    releasable = True
    releasers = RELEASERS
    calc_md5 = True
    share = True


class AdfoxConfigurationRaw(sdk2.Resource):
    """
        json file with engine/bridge/countersd configuration
    """
    auto_backup = True
    calc_md5 = True
    share = True


# DEPLOY YA PACKAGE LAYERS


class AdfoxLayer(YaPackageResource):
    auto_backup = True
    releasable = True
    releasers = RELEASERS
    calc_md5 = True
    share = True


class AdfoxEngineInfraLayer(AdfoxLayer):
    pass


class AdfoxEngineBinaryLayer(AdfoxLayer):
    pass


class AdfoxAmacsBinary(AdfoxEngineBinaryLayer):
    pass


class AdfoxEngineConfigurationLayer(AdfoxLayer):
    pass


class AdfoxPredictorBinaryLayer(AdfoxLayer):
    pass


class AdfoxPredictorLoaderLayer(AdfoxLayer):
    pass


class AdfoxPredictorInfraLayer(AdfoxLayer):
    pass


class AdfoxYabsmonBinaryLayer(AdfoxLayer):
    pass


class AdfoxYabsmonSchedulerLayer(AdfoxLayer):
    pass


class AdfoxYabsmonWorkerChLayer(AdfoxLayer):
    pass


class AdfoxYabsmonWorkerYtLayer(AdfoxLayer):
    pass


class AdfoxYabsmonWorkerHttpLayer(AdfoxLayer):
    pass


class AdfoxSolomonAgentBinaryLayer(AdfoxLayer):
    pass


class AdfoxMatchidBinaryLayer(AdfoxLayer):
    pass


class ADFOX_PDB3_BINARY_LAYER(AdfoxLayer):
    pass


class ADFOX_PDB3_DISCOVERY_BINARY_LAYER(AdfoxLayer):
    pass


class AdfoxSdBinaryLayer(AdfoxLayer):
    pass


class AdfoxRegistratorBinaryLayer(AdfoxLayer):
    pass


class AdfoxPushClientBinaryLayer(AdfoxLayer):
    pass


class AdfoxPushClientConfigurationLayer(AdfoxLayer):
    pass


class AdfoxXpdBinaryLayer(AdfoxLayer):
    pass


class AdfoxNginxConfigurationLayer(AdfoxLayer):
    pass


class AdfoxSaasCoordinatorBinaryLayer(AdfoxLayer):
    pass


class AdfoxSaasControllerBinaryLayer(AdfoxLayer):
    pass


class AdfoxSaasWorkerBinaryLayer(AdfoxLayer):
    pass


class AdfoxSaasGcBinaryLayer(AdfoxLayer):
    pass


class AdfoxSaasDeployerBinaryLayer(AdfoxLayer):
    pass


class AdfoxSaasKvrsBinaryLayer(AdfoxLayer):
    pass


class AdfoxEngineDataLayer(AdfoxLayer):
    pass


class AdfoxCountersd2BinaryLayer(AdfoxLayer):
    pass


# DEPLOY PORTO LAYERS

class PORTO_LAYER_ADFOX(sdk2.Resource):
    auto_backup = True
    releasable = True
    releasers = RELEASERS
    share = True


class PORTO_LAYER_ADFOX_MATCHID_INFRA(PORTO_LAYER_ADFOX):
    pass


class PORTO_LAYER_ADFOX_NGINX_INFRA(PORTO_LAYER_ADFOX):
    pass


class PORTO_LAYER_ADFOX_ENGINE_INFRA(PORTO_LAYER_ADFOX):
    pass

# DEPLOY DOCKER LAYERS
# ...
