# -*- coding: utf-8 -*-
import logging
import re
import socket

from sandbox.sandboxsdk import environments
from sandbox import sdk2
from sandbox.common import telegram

YAV_SECRET_ID = 'sec-01e3h2pyr3wyjfxq91pa4s6ybv'
SUPPORT_CHAT_ID = '-1001361799205'

socket.setdefaulttimeout(60)


class Action(object):
    SLA_EXPIRING = 0
    SLA_EXPIRED = 1
    TASK_CREATED = 2


def get_action(subject):
    if subject == u'Задача создана':
        return Action.TASK_CREATED
    else:
        words = subject.split()
        if words[0] == 'SLA':
            if u'истечёт' in words:
                return Action.SLA_EXPIRING
            elif u'нарушен' in words:
                return Action.SLA_EXPIRED
        else:
            return None


class AdfoxSupportGetTasks(sdk2.Task):
    name = 'ADFOX_SUPPORT_GET_TASKS'

    class Requirements(sdk2.Task.Requirements):
        environments = (
            environments.PipEnvironment('emoji'),
            environments.PipEnvironment('imapy')
        )

    def on_execute(self):
        import imapy
        from emoji import emojize

        secret = sdk2.yav.Secret(YAV_SECRET_ID)

        def send_ticket(ticket_dict):
            logging.info('Sending ticket: {0}'.format(ticket_dict['ticket']))
            prefix = ''
            if ticket_dict['action'] == Action.SLA_EXPIRING:
                prefix = '*Истекает SLA* {0}'.format(emojize(':warning:', use_aliases=True))
            elif ticket_dict['action'] == Action.SLA_EXPIRED:
                prefix = '*Истёк SLA* {0}'.format(emojize(':bangbang:', use_aliases=True))
            else:
                return
            response = '\n'.join([
                prefix, ticket_dict['ticket'], '*{0}*'.format(ticket_dict['theme']), ticket_dict['url']
            ])
            telegram.TelegramBot(secret.data()['TELEGRAM_API_KEY']).send_message(
                chat_id=SUPPORT_CHAT_ID, text=response, parse_mode=telegram.ParseMode.MARKDOWN)

        email_api = imapy.connect(host='imap.yandex-team.ru', username=secret.data()['MAIL_LOGIN'],
                                  password=secret.data()['MAIL_PASSWORD'], ssl=True)
        emails = email_api.folder('ST').emails()
        for email in emails:
            try:
                ticket = re.findall(r'ADFOX-\d*|PISUP-\d*|DPA-\d*', email['subject'])[0]
                logging.info('Found ticket: {0}'.format(ticket))
                send_ticket({
                    'ticket': ticket,
                    'url': 'https://st.yandex-team.ru/{0}'.format(ticket),
                    'action': get_action(re.findall(r'^\[(.*?)\]', email['subject'])[0]),
                    'theme': re.findall(r'\) (.*?) \[ST\]$', email['subject'])[0]
                })
                email.move('ST-processed')
            except IndexError:
                pass
        email_api.logout()
