import pyjsonrpc
from datetime import datetime, timedelta
import logging
import time


class GetEventHorizon:

    def __init__(self, params):
        self.params = params

    def get_event_horizon(self):
        ch_event_horizon = self.ch_rtd_request('event_horizon')
        logging.info('event_horizon is {}'.format(ch_event_horizon))
        event_horizon = datetime.strptime(ch_event_horizon, '%Y-%m-%d %H:%M:%S')
        return event_horizon

    def ch_rtd_request(self, method, **kwargs):
        client = pyjsonrpc.HttpClient(self.params['host'])
        task_id = client.call(method, **kwargs)
        time_run = 0
        state = ''
        while state != 'SUCCESS' and time_run < self.params['max_wait_result']:
            state = client.get_task_state(task_id)
            if state == 'FAILURE':
                logging.error(client.get_task_result(task_id))
                raise Exception
            time.sleep(self.params['repeat_check'])
            time_run += self.params['repeat_check']
        result = dict()
        # celery sets status 'SUCCESS' before result data is actually available, so we check result on non-empty
        while (len(result) == 0 or type(result) is dict and len(result['fields']) == 0) \
                and time_run < self.params['max_wait_result']:
            result = client.call("get_task_result", task_id)
            time.sleep(self.params['repeat_check'])
            time_run += self.params['repeat_check']
        return result

