import logging
from sandbox import sdk2
import requests


class AdfoxUriCaller(sdk2.Task):
    """ This task call your uri. """

    class Parameters(sdk2.Task.Parameters):
        uri = sdk2.parameters.Url("URI for call", required=True)
        with sdk2.parameters.RadioGroup("HTTP method for call") as method:
            method.values.GET = method.Value(default=True)
            method.values.POST = None
            method.values.PUT = None
            method.values.DELETE = None

        query_parameters = sdk2.parameters.Dict("Parameters for call")
        json = sdk2.parameters.JSON("POST JSON")

    def on_execute(self):
        if self.Parameters.method == "GET":
            response = requests.get(self.Parameters.uri, params=self.Parameters.query_parameters)
        elif self.Parameters.method == "POST":
            response = requests.post(self.Parameters.uri, self.Parameters.query_parameters, self.Parameters.json)
        elif self.Parameters.method == "PUT":
            response = requests.put(self.Parameters.uri, self.Parameters.query_parameters)
        elif self.Parameters.method == "DELETE":
            response = requests.delete(self.Parameters.uri)
        else:
            raise RuntimeError

        logging.info("Response status: {}".format(response.status_code))
        logging.info("Response headers: {}".format(response.headers))
        logging.info("Response data: {}".format(response.content))
