from sandbox import sdk2
from sandbox.projects import resource_types


class YangConversionBannersBin(sdk2.Resource):
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = ['rudolf', 'ekondranin', 'muradmazitov']
    release_subscribers = ['rudolf', 'muradmazitov']
    __default_attribute__ = sdk2.parameters.String


class AmMrUtils(resource_types.ARCADIA_PROJECT):
    """
    resource with arcadia/ads/quality/adv_machine/tools/mr_utils/am_mr_utils binary
    """
    auto_backup = True
    any_arch = True
    releasers = ["dpaveldev", "rudolf", "fdrstrok", "robot-tlm"]
    releasable = True
    release_subscribers = ["fdrstrok"]


class YtFindUnused(resource_types.ARCADIA_PROJECT):
    """
    resource with arcadia/ads/tools/yt_find_unused
    """
    auto_backup = True
    any_arch = True
    releasers = ["fdrstrok", "insight", "robot-tlm"]
    releasable = True
    release_subscribers = ["fdrstrok"]
