from typing import List, Dict, Tuple

from sandbox.projects.ads.emily.tasks.export_lm_scheme_and_config.lib.tables import TableNames

__SCHEME_SAFENESS_THRESHOLD = 0.8
__KEY_FIELDS_IN_CONFIG = ("LinearModelID", "DumpName", "ModelName")


def __row_to_key_tuple_config(row: Dict):
    return tuple(row[field] for field in __KEY_FIELDS_IN_CONFIG)


def __to_set_of_key_config_fields(config_table: List[Dict]):
    return {__row_to_key_tuple_config(row) for row in config_table}


def is_safe_diff(old_tables: Dict[str, List[Dict]], new_tables: Dict[str, List[Dict]]) -> Tuple[bool, List[str]]:
    safeness = True
    error_strs = []
    new_scheme_len = len(new_tables[TableNames.LM_SCHEME])
    old_scheme_len = len(old_tables[TableNames.LM_SCHEME])
    if new_scheme_len < __SCHEME_SAFENESS_THRESHOLD * old_scheme_len:
        safeness = False
        error_strs.append(
            f"New len of {TableNames.LM_SCHEME}={new_scheme_len} is less than "
            f"{__SCHEME_SAFENESS_THRESHOLD} * (old len={old_scheme_len})"
        )

    new_config_key_tuples = __to_set_of_key_config_fields(new_tables[TableNames.LM_CONFIG])
    old_config_key_tuples = __to_set_of_key_config_fields(old_tables[TableNames.LM_CONFIG])
    if not new_config_key_tuples.issuperset(old_config_key_tuples):
        safeness = False
        error_strs.append(f"Deletions in new {TableNames.LM_CONFIG}: {old_config_key_tuples - new_config_key_tuples}")
    return safeness, error_strs
