from sandbox import sdk2

from sandbox.projects.ads.emily.tasks.export_lm_scheme_and_config.lib.py23.modes import Modes
from sandbox.projects.ads.emily.resources import MlStorageLmConfig, MlStorageLmScheme


class Parameters(sdk2.Task.Parameters):  # pylint: disable=too-few-public-methods # noqa
    description = "Export LinearModelConfig and LinearModelSet to YT"
    yt_token = sdk2.parameters.YavSecret(
        "Yav secret with YT token",
        default="sec-01d4nnsjv51k0rqtr5fv6qyz8w",
        required=True
    )
    clusters = sdk2.parameters.List(
        "YT clusters (proxies) to export keywords to",
        default=["freud", "hahn", "arnold"],
        required=True
    )
    yt_dir_path = sdk2.parameters.String(
        "Path to workdir in ALL clusters",
        default="//home/yabs/dict",
        required=True
    )
    lm_config_content = sdk2.parameters.Resource(
        ".json file with LinearModelConfig content",
        resource_type=MlStorageLmConfig,
        required=True)
    lm_scheme_content = sdk2.parameters.Resource(
        ".json file with LinearModelScheme content",
        resource_type=MlStorageLmScheme,
        required=True)
    with sdk2.parameters.String("Mode", required=True) as mode:
        mode.values[Modes.FULL_MODE] = mode.Value(Modes.FULL_MODE, default=True)
        mode.values[Modes.ONLY_CREATE_SNAPSHOT] = Modes.ONLY_CREATE_SNAPSHOT
        mode.values[Modes.ONLY_CHANGE_LINKS] = Modes.ONLY_CHANGE_LINKS
    with mode.value[
        "Only change tables links; use it to revert to older tables"]:  # IDK how to fix that, using proper enum value breaks everything # noqa
        snapshot_id = sdk2.parameters.String("Target suffix for snapshot (all table names end with it).",
                                             required=True)
    extremely_dangerous_disable_snapshot_verification = sdk2.parameters.Integer(
        "REALLY DANGEROUS! Input current UNIX timestamp (timezone independent! in seconds, with error < 1000) to "
        "disable snapshot verification.",
        default=0,
    )
