from sandbox import sdk2
import sandbox.common.types.task as ctt
import sandbox.common.types.resource as ctr

from sandbox.projects.logos.run_script_2.lib import RunScript2
from sandbox.projects.ads.emily.tasks.export_lm_scheme_and_config.lib.py23.sandbox_parameters import Parameters as ExportParameters  # noqa E501


class ExportParametersWithAutosearch(ExportParameters):
    lm_config_content = None
    lm_scheme_content = None
    lm_config_search_config = sdk2.parameters.JSON("SB search config for LM config resource", required=True)
    lm_scheme_search_config = sdk2.parameters.JSON("SB search config for LM scheme resource", required=True)


class RunScript2AndExportLms(RunScript2):
    class Parameters(RunScript2.Parameters):
        with sdk2.parameters.Group("Export params") as export_params_group:
            export_params = ExportParametersWithAutosearch

    def on_execute(self):
        with self.memoize_stage.execute_script(commit_on_entrance=False):
            super(RunScript2AndExportLms, self).on_execute()
        with self.memoize_stage.export_task(commit_on_entrance=False):
            task = self.server.task({
                'type': 'EXPORT_LINEAR_MODEL_TABLES_TO_YT',
                'description': 'Export LinearModelScheme and LinearModelConfig to YT',
                'children': True,
                'owner': self.owner,
                'notifications': self.server.task[self.id].read()['notifications'],
                'requirements':
                    {'tasks_resource': sdk2.Resource.find(
                        attrs={
                            "task_type": "EXPORT_LINEAR_MODEL_TABLES_TO_YT",
                            "released": "stable"
                        },
                        status=ctr.State.READY
                    ).first().id},
                'custom_fields': [{'name': k, 'value': v} for k, v in dict(
                    yt_token=str(self.Parameters.yt_token),
                    clusters=self.Parameters.clusters,
                    yt_dir_path=self.Parameters.yt_dir_path,
                    lm_config_content=self.find_resource(self.Parameters.export_params.lm_config_search_config),
                    lm_scheme_content=self.find_resource(self.Parameters.export_params.lm_scheme_search_config),
                    mode=self.Parameters.mode,
                ).items()],
            })
            task_id = task['id']
            self.server.batch.tasks.start.update([task_id])
        with self.memoize_stage.wait_for_export(commit_on_entrance=True):
            raise sdk2.WaitTask([task_id], (ctt.Status.Group.FINISH, ctt.Status.Group.BREAK), wait_all=True)
