from sandbox import sdk2


def get_all_subclasses(cls):
    subclasses = set()
    has_subs = [cls]
    while has_subs:
        parent = has_subs.pop()
        for child in parent.__subclasses__():
            if child not in subclasses:
                subclasses.add(child)
                has_subs.append(child)
    return subclasses


RESOURCES = get_all_subclasses(sdk2.Resource)


def get_all_resource_types():
    return sorted(str(cls) for cls in RESOURCES)


def get_resource_link(resouce_id):
    # type: (int) -> str
    return "<a href=\"https://sandbox.yandex-team.ru/resource/{id}/view\">{id}</a>".format(id=resouce_id)


def get_task_link(task_id):
    # type: (int) -> str
    return "<a href=\"https://sandbox.yandex-team.ru/task/{id}/view\">{id}</a>".format(id=task_id)


def get_colored_text(text, color):
    # type: (str, str) -> str
    return "<span style=\"color:{color};\">{text}</span>".format(text=text, color=color)
