from sandbox import sdk2
import sandbox.common.types.resource as ctr
from sandbox.sdk2.helpers import subprocess as sp


class AdsEShowExperimentDictUpdater(sdk2.Resource):
    """Binary to synchronize AB testids and EShowExpID"""
    releasable = True
    releasers = ["alex-serov", "berezniker"]


class AdsEShowUpdateExperimentDict(sdk2.Task):
    """Task to run compiled binary for AB experiments updater"""

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 1 * 24 * 60

        binary_path = sdk2.parameters.LastReleasedResource(
            "AB Updater binary",
            resource_type=AdsEShowExperimentDictUpdater,
            state=(ctr.State.READY, ), required=True
        )

        ab_conf_version = sdk2.parameters.Integer(
            "AB config version to parse. If empty or zero - will take to latest active",
            required=False, default=0
        )
        ab_conf_enum = sdk2.parameters.Integer(
            "Enumeration of relevant AB config",
            required=False, default=144
        )
        ab_dimensions = sdk2.parameters.List(
            "AB dimensions to grep ExpIDs from",
            required=True
        )
        secret_name = sdk2.parameters.YavSecret(
            "Secret in YAV with access to YT. Use #key for key",
            required=True
        )
        yt_proxy = sdk2.parameters.String(
            "YT cluster",
            required=False, default="hahn"
        )
        yt_table_path = sdk2.parameters.String(
            "Path to yt table to store experiments data",
            required=False
        )
        zero_ab_conf_version = sdk2.parameters.Integer(
            "Leftmost AB config version to use if no table found",
            required=False, default=600
        )

    def on_execute(self):
        binary_path = str(sdk2.ResourceData(self.Parameters.binary_path).path)
        cmd = [binary_path, "--ab_dimensions"]
        cmd.extend(map(str, self.Parameters.ab_dimensions))

        if self.Parameters.ab_conf_version:
            cmd.extend(["--ab_conf_version", str(self.Parameters.ab_conf_version)])

        if self.Parameters.ab_conf_enum:
            cmd.extend(["--ab_conf_enum", str(self.Parameters.ab_conf_enum)])

        if self.Parameters.yt_table_path:
            cmd.extend(["--yt_table_path", self.Parameters.yt_table_path])

        if self.Parameters.zero_ab_conf_version:
            cmd.extend(["--zero_ab_conf_version", str(self.Parameters.zero_ab_conf_version)])

        env_vars = {
            "YT_PROXY": self.Parameters.yt_proxy,
            "YT_TOKEN": self.Parameters.secret_name.data()[self.Parameters.secret_name.default_key]
        }

        with sdk2.helpers.ProcessLog(self, logger="ab_updater_log") as pl:
            sp.check_call(cmd, stdout=pl.stdout, stderr=sp.STDOUT, env=env_vars)
