import itertools
from textwrap import dedent

ACTION_FIELD = "APC"
BID_FIELD = "Bid"
BILL_FIELD = "Billed"
GROUP_ID_FIELD = "GID"
WEIGHT_FIELD = "Weight"
IS_EXP_FIELD = "IsExp"
USER_BUCKET_FIELD = "UserBucket"

CONTROL_EXP_ID = 0
STDDEV_K = 1.465234
COST_EPS = 319.1076583480 / 100.0

APC_SCHEMA = [
    {"name": GROUP_ID_FIELD, "type": "uint32"},
    {"name": ACTION_FIELD, "type": "double"},
    {"name": BID_FIELD, "type": "int32"},
    {"name": WEIGHT_FIELD, "type": "double"},
    {"name": IS_EXP_FIELD, "type": "int32"}
]
APC_SCHEMA_WITH_USER_BUCKET = list(itertools.chain(
    APC_SCHEMA,
    (
        {"name": BILL_FIELD, "type": "int32"},
        {"name": USER_BUCKET_FIELD, "type": "int32"},
    )
))

ZC_APC_METHODS = [
    "bids_ratio", "bids_ratio_1", "bids_ratio_2", "actions_ratio", "iter",
    "zc_2", "z1", "mse", "bc", "bc_inv", "qsoftmax", "cpa_qsoftmax", "gsoftmax"
]

COMMERCE_ALL = "all"
COMMERCE_ONLY_COMMERCE = "only_commerce"
COMMERCE_ONLY_NOT_COMMERCE = "only_not_commerce"

AB_EXP_PREFIX = "ab"
PCODE_EXP_PREFIX = "pcode"
YA_EXP_PREFIX = "yaexp"

EXP_PREFIXES = {
    AB_EXP_PREFIX: "ActiveTestIds",
    PCODE_EXP_PREFIX: "PcodeTestIds",
    YA_EXP_PREFIX: "YandexExpBoxes"
}

MODE_PREMAP = "premap"
MODE_RUN_APC_CHECK = "run-apc-check"
MODE_CALC_USER_BUCKET_STATS = "calculate-user-bucket-stats"
MODE_DO_NOTHING = "do-nothing"

ATTR_EXPID = "__experiment_id"
ATTR_ACTION = "__action"
ATTR_ACTION_VIEW = "__action_view"
ATTR_IS_CONTROL = "__is_control"

HTML_STYLE = dedent("""
    <style type="text/css">
        table {
            table-layout: fixed;
            width: 100%;
            border-collapse: collapse;
            border: 1px solid black;
            text-align: center;
        }
        tr {
            border: 1px solid black;
        }
        th {
            border: 1px solid black;
        }
        td {
            border: 1px solid black;
        }
    </style>
""")
