import logging
import shutil

from .constants import APC_SCHEMA

APC_INPUT_FIELDS_ORDER = [field["name"] for field in APC_SCHEMA]


def read_yt_table_to_file(table_path, file_path, yt_client, header=True, append=False, unordered=False):
    from yt.wrapper import SchemafulDsvFormat, TablePath

    logging.info("Reading table {} to file {}".format(table_path, file_path))

    with yt_client.Transaction(attributes={"title": "Reading table {} for zC calculation".format(table_path)}):
        with open(file_path, "ab" if append else "wb") as fh:
            if header:
                fh.write("# {}\n".format("\t".join(APC_INPUT_FIELDS_ORDER)).encode("utf-8"))

            read_format = SchemafulDsvFormat(APC_INPUT_FIELDS_ORDER, enable_escaping=True)
            shutil.copyfileobj(
                fsrc=yt_client.read_table(
                    TablePath(table_path, columns=APC_INPUT_FIELDS_ORDER),
                    format=read_format, unordered=unordered, raw=True
                ),
                fdst=fh
            )
