DICT_DELIM = "::"


def encode_dict(dct):
    res = dict()

    for (k, v) in dct.items():
        if isinstance(k, tuple):
            res[DICT_DELIM.join(map(str, k))] = v
        else:
            res[str(k)] = v

    return res


def decode_dict(dct):
    res = dict()

    for (k, v) in dct.items():
        key_atoms = []

        for atom in k.split(DICT_DELIM):
            key_atoms.append(int(atom) if atom.isdigit() else atom)

        if len(key_atoms) == 1:
            res[key_atoms[0]] = v
        else:
            res[tuple(key_atoms)] = v

    return res
