import re


def parse_svn_revision(
        arc_branch  # type: str
):  # type: (...) -> str

    for version in (
        r"^r(\d+)$",  # trunk
        r"^releases/logos/.*r(\d+)$",  # release branch
    ):
        match = re.match(version, arc_branch)
        if match is not None:
            return match.groups()[0]
    raise RuntimeError("Can't extract arcadia revision from {}".format(arc_branch))


def parse_project(
        binary_path  # type: str
):  # type: (...) -> str

    match = re.match(r"^logos/projects/(\w+)/.*$", binary_path)
    if match is not None:
        return match.groups()[0]
    raise ValueError("Can't extract project from binary path: {}".format(binary_path))
