from sandbox import sdk2


RELEASERS = ["robot-logos", "robot-logos-preprod", "npytincev", "ilariia", "ohmikey", "dim-gonch", "LOGOS"]


class LogosBinary(sdk2.Resource):
    """ Mono binary for run and update logos graph """
    releasable = True
    auto_backup = True
    releasers = RELEASERS
    arcadia_revision = sdk2.parameters.String("Svn revision", default=None)
    nile_udf_resource_id = sdk2.parameters.String("Nile udf resource", default=None)


class AdsInfraMonoBinary(sdk2.Resource):
    """ Mono binary for run and update logos graph """
    releasable = True
    auto_backup = True
    releasers = RELEASERS
    arcadia_revision = sdk2.parameters.String("Svn revision", default=None)
    nile_udf_resource_id = sdk2.parameters.String("Nile udf resource", default=None)


class LogosMonoNileUdf(sdk2.Resource):
    """ Mono udf for running nile over YQL tasks """
    releasable = True
    auto_backup = True
    ttl = 999
    releasers = RELEASERS
    arcadia_revision = sdk2.parameters.String("Svn revision", default=None)


class LogosLogsBinary(sdk2.Resource):
    """ Binary for logs graph-independent processing """
    releasable = True
    auto_backup = True
    releasers = RELEASERS
    arcadia_revision = sdk2.parameters.String("Svn revision", default=None)


class LogosGraphDoc(sdk2.Resource):
    """ Graph doc json for Logos Viewy (LOGOSWEB-591) """
    releasable = True
    auto_backup = True
    releasers = RELEASERS
    any_arch = True
    ttl = 999
    arcadia_revision = sdk2.parameters.String("Svn revision", default=None)
    release_name = sdk2.parameters.String("Release name", default=None)
    project = sdk2.parameters.String("Project", default=None)


class LogosMetagraphDoc(sdk2.Resource):
    """ Meta-Graph doc json for Logos Viewy (LOGOS-2363) """
    releasable = True
    auto_backup = True
    releasers = RELEASERS
    any_arch = True
    ttl = 99
    arcadia_revision = sdk2.parameters.String("Svn revision", default=None)


class AdsLogosDocs(sdk2.Resource):
    """ Logos Documentation docs.tar.gz """
    auto_backup = True
    any_arch = True
    ttl = 999
    arcadia_revision = sdk2.parameters.String("Svn revision", default=None)


class AdsLogosLogs(sdk2.Resource):
    """ Logos Logs Schemas logs.tar.gz """
    auto_backup = True
    any_arch = True
    ttl = 999
    arcadia_revision = sdk2.parameters.String("Svn revision", default=None)


# Deploy Logos Viewy Resources

class LogosViewyDocker(sdk2.Resource):
    """ Logos Viewy Docker Image Resource """
    releasable = True


class LogosViewyBackend(sdk2.Resource):
    """ Logos Viewy Backend Binary Resource """
    releasable = True


# Migrate Logos Viewy binary

class LogosViewyMigrateTool(sdk2.Resource):
    """ Logos Viewy Docker Image Resource """
    releasable = True
    auto_backup = True
    any_arch = True
    ttl = "inf"
    arcadia_revision = sdk2.parameters.String("Svn revision", default=None)


class SphinxDocs(sdk2.Resource):
    """ Sphinx-generated Documentation """
    auto_backup = True
    any_arch = True
    ttl = 999
    arcadia_revision = sdk2.parameters.String("Svn revision", default=None)
