from sandbox import sdk2
from sandbox.common.types import client as ctc
from sandbox.sdk2.helpers import subprocess as sp

from sandbox.projects.common import task_env


class AdsLogosReleaseSchedule(sdk2.Resource):
    pass


class AdsLogosReleaseReport(sdk2.Resource):
    pass


class AdsLogosReleaseWatchman(sdk2.Task):
    class Requirements(task_env.TinyRequirements):
        ram = 1024
        disk_space = 2048  # 2 Gb
        # exclude hosts without AVX support
        client_tags = (ctc.Tag.GENERIC | ctc.Tag.MULTISLOT) & ~ctc.Tag.INTEL_E5645
        container_resource = 2796964077

    """Stub for release watchman"""
    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 60 * 60 * 24
        with sdk2.parameters.RadioGroup("Release environment", per_line=3) as release_env:
            release_env.values.prod = release_env.Value(value="prod")
            release_env.values.preprod = release_env.Value(value="preprod")
            release_env.values.dev = release_env.Value(value="dev", default=True)
        max_failed_instances = sdk2.parameters.Integer("Max failed instances", default=10)
        max_runtime = sdk2.parameters.Integer("Max release tuntime in seconds", default=86400)
        poll_release_timeout = sdk2.parameters.Integer("Interval between polls in seconds", default=300)
        mail_to = sdk2.parameters.List("Staff logins of recipients")
        schedule_file = sdk2.parameters.Resource("Schedule file")
        logos_secret = sdk2.parameters.YavSecret("Logos secret in yav created by robot-nirvana. Use #key for key.")
        nirvana_secret_name = sdk2.parameters.String("Name of logos secret created by robot-nirvana")
        logos_binary = sdk2.parameters.Resource("Logos binary")
        whitelist = sdk2.parameters.String("Whitelist")
        yt_pool = sdk2.parameters.String("Yt pool for diff")

    def on_execute(self):
        binary_path = str(sdk2.ResourceData(self.Parameters.logos_binary).path)
        schedule_file_path = str(sdk2.ResourceData(self.Parameters.schedule_file).path)
        report_file = "report.html"
        command_line = [binary_path]
        if self.Parameters.release_env != "dev":
            command_line.extend([
                "--{}".format(self.Parameters.release_env),
                "wait-for-release"
            ])
        else:
            command_line.extend([
                "wait-for-release",
                "--nirvana-secret-name", self.Parameters.nirvana_secret_name
            ])
        command_line.extend([
            "--wait-localy",
            "--user", self.author,
            "--max-failed-instances", str(self.Parameters.max_failed_instances),
            "--max-runtime", str(self.Parameters.max_runtime),
            "--poll-release-timeout", str(self.Parameters.poll_release_timeout),
            "--html-report-file", report_file
        ])
        command_line.extend([
            "--schedule-file", schedule_file_path
        ])
        if self.Parameters.yt_pool:
            command_line.extend([
                "--yt-pool", self.Parameters.yt_pool
            ])
        if self.Parameters.whitelist:
            whitelist_file_path = "whitelist"
            with open(whitelist_file_path, "w") as whitelist_file:
                whitelist_file.write(self.Parameters.whitelist)
            command_line.extend([
                "--whitelist", whitelist_file_path
            ])
        if self.Parameters.mail_to:
            command_line.extend([
                "--mail-to", " ".join(self.Parameters.mail_to)
            ])
        logos_binary_env = {
            "LOGOS_TOKEN": self.Parameters.logos_secret.data()[self.Parameters.logos_secret.default_key]
        }
        with sdk2.helpers.ProcessLog(self, logger="logos_binary") as pl:
            sp.check_call(command_line, stdout=pl.stdout, stderr=sp.STDOUT, env=logos_binary_env)
        report_resource = AdsLogosReleaseReport(
            self,
            "Report for task {}".format(self.id),
            report_file
        )
        sdk2.ResourceData(report_resource).ready()
        self.Context.logos_report_id = report_resource.id

        with open(report_file) as report:
            self.Context.report = report.read().strip()
        self.Context.save()

    @sdk2.footer(title="Preprod report.html")
    def report(self):
        return self.Context.report or "Task failed before generating report"
