import os

from sandbox import sdk2


class RunReactorScript(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        yt_token_owner = sdk2.parameters.String(
            "YT token owner",
            required=True
        )

        yt_token_name = sdk2.parameters.String(
            "YT token name",
            required=True
        )

        reactor_token_owner = sdk2.parameters.String(
            "Reactor token owner",
            required=True
        )

        reactor_token_name = sdk2.parameters.String(
            "Reactor token name",
            required=True
        )

        script_binary = sdk2.parameters.Resource('Script binary', required=True)

    def get_env_with_tokens(self):
        env = os.environ.copy()
        env['YT_TOKEN'] = sdk2.Vault.data(self.Parameters.yt_token_owner, self.Parameters.yt_token_name)
        env['REACTOR_TOKEN'] = sdk2.Vault.data(self.Parameters.reactor_token_owner, self.Parameters.reactor_token_name)
        return env

    def on_execute(self):
        binary_path = str(sdk2.ResourceData(self.Parameters.script_binary).path)

        cmd = [
            binary_path
        ]

        with sdk2.helpers.ProcessLog(self, logger='script_out') as pl:
            sdk2.helpers.subprocess.check_call(
                cmd,
                env=self.get_env_with_tokens(),
                stdout=pl.stdout,
                stderr=pl.stderr
            )
