import sandbox.sdk2 as sdk2


class NirvanaRegularProcessState(sdk2.Resource):
    """
    Resource with converted templates for rr priemka
    """
    auto_backup = True
    any_arch = True
    process_id = sdk2.Attributes.String("process_id", required=True)


class NirvanaOperationsBinary(sdk2.Resource):
    """Program ads/nirvana/tools/commands"""
    releasable = True
    releasers = ['mstebelev', 'alb82', 'ML-ENGINE']


class MlEngineRegularTask(sdk2.Resource):
    """ml-engine regular task"""
    releasable = True
    releasers = ['mstebelev', 'alb82', 'shoutpva', 'ilariia', 'npytincev', 'sameg', 'insight', 'ML-ENGINE']


class MlEngineLogCreator(sdk2.Resource):
    """learn logs binary resource"""
    releasable = True
    releasers = ['mstebelev', 'alb82', 'shoutpva', 'ilariia', 'ML-ENGINE']


class BidCorrectionWorkflowConstructor(sdk2.Resource):
    """bid_correction/workflow_constructor binary resource"""
    releasable = True
    releasers = ['sameg', 'druxa', 'vechkasova', 'serkh', 'AUTOBUDGET', 'ML-ENGINE']


class PositionalModelBinary(sdk2.Resource):
    """positional model graph creator binary resource"""
    releasable = True
    releasers = ['mstebelev', 'alb82', 'ML-ENGINE']


class LmInterpretRegularTask(sdk2.Resource):
    """lm interpret regular task"""
    releasable = True
    releasers = ['iyudintsev', 'shoutpva']
