from sandbox import sdk2


class TorchTsarUserModel(sdk2.Resource):
    """Resource with user part of factorization model learned by ads/pytorch"""
    uri = sdk2.Attributes.String("URI that obtained from artifact value attribute", required=True)
    value_path = sdk2.Attributes.String("YT path to value that was processed into resource", required=True)
    model_id = sdk2.Attributes.Integer("Model ID to distinguish different architectures", required=False)
    releasable = True


class TorchTsarBannerModel(sdk2.Resource):
    """Resource with banner part of factorization model learned by ads/pytorch"""
    uri = sdk2.Attributes.String("URI that obtained from artifact value attribute", required=True)
    value_path = sdk2.Attributes.String("YT path to value that was processed into resource", required=True)
    model_id = sdk2.Attributes.Integer("Model ID to distinguish different architectures", required=False)
    releasable = True


class TorchTsarPageModel(sdk2.Resource):
    """Resource with page part of factorization model learned by ads/pytorch"""
    uri = sdk2.Attributes.String("URI that obtained from artifact value attribute", required=True)
    value_path = sdk2.Attributes.String("YT path to value that was processed into resource", required=True)
    model_id = sdk2.Attributes.Integer("Model ID to distinguish different architectures", required=False)
    releasable = True


class TorchTsarTensorModel(sdk2.Resource):
    """Resource with tensor from factorization model learned by ads/pytorch"""
    uri = sdk2.Attributes.String("URI that was obtained from artifact value attribute", required=True)
    value_path = sdk2.Attributes.String("YT path to value that was processed into resource", required=True)
    model_id = sdk2.Attributes.Integer("Model ID to distinguish different architectures", required=False)
    releasable = True


class TorchTsarProcessorBinary(sdk2.Resource):
    auto_backup = True
    calc_md5 = True
    share = True
    releasers = ["alxmopo3ov", "ya-philya", "robot-online-pytorch"]
    release_subscribers = ["alxmopo3ov", "ya-philya"]
    releasable = True


class TorchArtifactCleaner(sdk2.Resource):
    auto_backup = True
    calc_md5 = True
    share = True
    releasers = ["alxmopo3ov", "ya-philya", "robot-online-pytorch"]
    release_subscribers = ["alxmopo3ov", "ya-philya"]
    releasable = True


class TorchBackupCollectorBinary(sdk2.Resource):
    auto_backup = True
    calc_md5 = True
    share = True
    releasers = ["alxmopo3ov", "ya-philya", "robot-online-pytorch"]
    release_subscribers = ["alxmopo3ov", "ya-philya"]
    releasable = True


class TorchTsarLtpModel(sdk2.Resource):
    """Resource with ltp_subnet part of factorization model learned by ads/pytorch"""
    uri = sdk2.Attributes.String("URI that obtained from artifact value attribute", required=True)
    value_path = sdk2.Attributes.String("YT path to value that was processed into resource", required=True)
    model_id = sdk2.Attributes.Integer("Model ID to distinguish different architectures", required=False)
    releasable = True


class RsyaBcTorchV2CombinedModel(sdk2.Resource):
    releasable = True
    releasers = ["blv1mk", "robot-online-pytorch"]


class RsyaBcTorchV2BannerModel(sdk2.Resource):
    releasable = True
    releasers = ["blv1mk", "robot-online-pytorch"]


class RsyaBcTorchV2ModelUploaderBinary(sdk2.Resource):
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = ["blv1mk", "basyl", "robot-online-pytorch"]
    release_subscribers = ["blv1mk", "basyl"]
