# -*- coding: utf-8 -*-

import logging
import shutil

from sandbox import sdk2
from sandbox.projects.common.build import parameters as ya_make_parameters
import sandbox.common.types.task as ctt

from sandbox.projects.adv_machine.common import AdvMachineReleaseTask
from sandbox.projects.adv_machine.build_adv_machine import ResourceDecs, get_release_services


logger = logging.getLogger(__name__)


class BuildAdvMachine2(AdvMachineReleaseTask):

    """Build Advmachine"""

    class Parameters(AdvMachineReleaseTask.Parameters):
        with sdk2.parameters.CheckGroup('Resources to build', default=[]) as resources:
            resources.choices = [(v.description, k) for k, v in ResourceDecs.iteritems()]

        ArcadiaUrl = ya_make_parameters.ArcadiaUrl()
        ArcadiaPatch = ya_make_parameters.ArcadiaPatch()
        BuildSystem = ya_make_parameters.BuildSystem()
        BuildType = ya_make_parameters.BuildType()
        Sanitize = ya_make_parameters.Sanitize()
        StripBinaries = ya_make_parameters.StripBinaries()
        UseArcadiaApiFuse = ya_make_parameters.UseArcadiaApiFuse(default_value=True)
        UseArcInsteadOfArcadiaApi = ya_make_parameters.UseArcInsteadOfArcadiaApi(default_value=False)
        LTO = ya_make_parameters.LTO()
        YtStore = ya_make_parameters.YtStore(default_value=True)
        YtTokenVault = ya_make_parameters.YtTokenVaultName(default_value='adv_machine_yt_token')

        release_services = AdvMachineReleaseTask.Parameters.release_services(choices=[(s, s) for s in get_release_services()])

    def on_execute(self):
        with self.memoize_stage.first:
            task_class = sdk2.Task["BUILD_ADV_MACHINE"]
            build_task = task_class(
                self,
                owner=self.Parameters.owner,
                priority=self.Parameters.priority,
                description=self.Parameters.description,
                resources=' '.join(self.Parameters.resources),
                checkout_arcadia_from_url=self.Parameters.ArcadiaUrl,
                arcadia_patch=self.Parameters.ArcadiaPatch,
                build_system=self.Parameters.BuildSystem,
                build_type=self.Parameters.BuildType,
                sanitize=self.Parameters.Sanitize,
                strip_binaries=self.Parameters.StripBinaries,
                use_aapi_fuse=self.Parameters.UseArcadiaApiFuse,
                use_arc_instead_of_aapi=self.Parameters.UseArcInsteadOfArcadiaApi,
                lto=self.Parameters.LTO,
                ya_yt_store=self.Parameters.YtStore,
                ya_yt_token_vault_name=self.Parameters.YtTokenVault
            ).enqueue()
            self.Context.build_task_id = build_task.id
            raise sdk2.WaitTask([build_task], list(ctt.Status.Group.FINISH + ctt.Status.Group.BREAK), True)

        with self.memoize_stage.second:
            built_resources = sdk2.Resource.find(task_id=self.Context.build_task_id).limit(0)
            for resource in built_resources:
                if resource.releasable:
                    data = sdk2.ResourceData(resource)
                    resource.type(
                        self,
                        resource.description,
                        data.path.name,
                        arcadia_branch=resource.arcadia_branch,
                        arcadia_revision=resource.arcadia_revision,
                        arcadia_trunk=resource.arcadia_trunk,
                        build_platform=resource.build_platform,
                        build_tool=resource.build_tool
                    )
                    shutil.copytree(str(data.path), data.path.name, True)
