# -*- coding: utf-8 -*-

import os
import logging

from sandbox.sandboxsdk.parameters import SandboxBoolGroupParameter

from sandbox.projects.common.build.YaMake import YaMakeTask

from sandbox.projects.common.nanny import nanny
from sandbox.projects.adv_machine.common import (
    resources, send_telegram_notification, BuildAdvMachineRobotBase, BuildAdvMachineBase
)


logger = logging.getLogger(__name__)


ResourceDecs = {
    'robot_bins': resources.AdvMachineRobotBin,
    'robot_cm': resources.AdvMachineRobotScripts,
    'release_tools': resources.AdvMachineReleaseTools,
    'export_ang_to_hahn': resources.AdvMachineExportAngBin,
    'download_data': resources.AdvMachineDownloadDataBin,
    'superapp_make_dicts': resources.SuperappMakeDictsBin,
}


class Resources(SandboxBoolGroupParameter):
    name = 'resources'
    required = True
    description = 'Robot resources'
    choices = [(v.description, k) for k, v in ResourceDecs.iteritems()]


class BuildAdvMachineRobot(BuildAdvMachineRobotBase):

    """Build adv machine robot binaries and scripts"""

    type = 'BUILD_ADV_MACHINE_ROBOT'

    additional_input_parameters = [
        Resources,
    ]
    input_parameters = BuildAdvMachineBase.input_parameters + additional_input_parameters

    def on_release(self, additional_parameters):
        YaMakeTask.on_release(self, additional_parameters)
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)

        resources = [_ for _ in self.list_resources() if _.type.releasable]
        send_telegram_notification(
            'Новые {} покатились. Бьет челом {}. Таск {}'.format(
                ', '.join([str(r.type) for r in resources]),
                additional_parameters['releaser'],
                self.http_url(),
            ),
            self.get_vault_data('ADV_MACHINE', 'adv_machine_telegram_bot_token')
        )

    def _chosen_resources(self):
        resource_names = self.ctx.get(Resources.name).strip().split()
        return ((name, ResourceDecs[name]) for name in resource_names)

    @staticmethod
    def _parse_arts(art, dst_prefix):
        splitted_art = art.split('=')
        dst = os.path.join(dst_prefix, splitted_art[1]) if len(splitted_art) > 1 else dst_prefix
        return {'path': splitted_art[0], 'dest': dst}


__Task__ = BuildAdvMachineRobot
