# -*- coding: utf-8 -*-

import logging

from sandbox.projects.adv_machine.common import (
    BuildAdvMachineRobotBase, BuildAdvMachineBase, BuildAdvMachineRobotParametersFactory
)

from sandbox.projects.adv_machine.common import resources


logger = logging.getLogger(__name__)


class BuildAdvMachineContentMerger2(BuildAdvMachineRobotBase):

    """Build AdvMachine ContentMerger robot binaries and scripts"""
    type = 'BUILD_ADV_MACHINE_CONTENT_MERGER_2'

    ResourceDecs = {
        'content_merger': {
            'description': 'Bins&Scripts',
            'type': resources.AdvMachineContentMergerPackage
        },
        'config': {
            'description': 'Config',
            'type': resources.AdvMachineConfig
        }
    }

    ReleaseServicesParameter = BuildAdvMachineRobotParametersFactory.generate_release_services(ResourceDecs)
    ItemsToBuild = BuildAdvMachineRobotParametersFactory.generate_items_to_build(ResourceDecs)

    additional_input_parameters = [
        ReleaseServicesParameter, ItemsToBuild
    ]
    input_parameters = BuildAdvMachineBase.input_parameters + additional_input_parameters


__Task__ = BuildAdvMachineContentMerger2
