# -*- coding: utf-8 -*-

import logging

from sandbox.projects.adv_machine.common import (
    BuildAdvMachineRobotBase, BuildAdvMachineBase, BuildAdvMachineRobotParametersFactory
)

from sandbox.projects.adv_machine.common import resources


logger = logging.getLogger(__name__)


class BuildAdvMachineEdadealRobot(BuildAdvMachineRobotBase):

    """Build EdadealMachine robot binaries and scripts"""
    type = 'BUILD_ADV_MACHINE_EDADEAL_ROBOT'

    ResourceDecs = {
        'edadeal_robot_bins': {
            'description': 'Everything for edadeal-machine robot',
            'type': resources.AdvMachineEdadealRobotPackage,
        },
    }

    ReleaseServicesParameter = BuildAdvMachineRobotParametersFactory.generate_release_services(ResourceDecs)
    ItemsToBuild = BuildAdvMachineRobotParametersFactory.generate_items_to_build(ResourceDecs)

    additional_input_parameters = [
        ReleaseServicesParameter, ItemsToBuild
    ]
    input_parameters = BuildAdvMachineBase.input_parameters + additional_input_parameters


__Task__ = BuildAdvMachineEdadealRobot
