# -*- coding: utf-8 -*-

import logging
import os

from sandbox.sandboxsdk.process import run_process


class AdvMachinePriemka:
    def __init__(self, bin_dir, ammo_file):
        self.bin_dir = bin_dir
        self.ammo_file = ammo_file

    def shoot(
        self,
        service_id,
        meta_port,
        meta_address='localhost',
        requests_count=3000,
        shelling_rps=200,
        timeout=160,
        output_file='output.txt'
    ):
        logging.info('Start shooting')

        cmd = [
            os.path.join(self.bin_dir, 'am_priemka'),
            'apphost_shelling',
            '-a', self.ammo_file,
            '--meta-address', meta_address,
            '--meta-port', str(meta_port),
            '--service-id', service_id,
            '-c', str(requests_count),
            '-R', str(shelling_rps),
            '-t', str(timeout),
            '-o', output_file,
        ]
        env = {'MKL_CBWR': 'COMPATIBLE'}

        return run_process(
            cmd,
            log_prefix='am_priemka',
            environment=env,
        )
