# -*- coding: utf-8 -*-

from sandbox import sdk2
import sandbox.common.types.resource as ctr

from sandbox.sdk2.helpers import subprocess as sp

from sandbox.projects.adv_machine.common import process_wrapper
from sandbox.projects.adv_machine.common import AdvMachineReleaseTask
from sandbox.projects.adv_machine.common.parameters import YTParameters
from sandbox.projects.adv_machine.common.resources import adv_machine_releasers, adv_machine_subscribers
from sandbox.projects.adv_machine.common.yt_params import get_yt_config


class AdvMachineDownloadFromYtBin(sdk2.Resource):
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = adv_machine_releasers
    release_subscribers = adv_machine_subscribers
    __default_attribute__ = sdk2.parameters.String


class AdvMachineDownloadFromYtTaskBase(AdvMachineReleaseTask):

    class Requirements(AdvMachineReleaseTask.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(AdvMachineReleaseTask.Parameters):
        yt = YTParameters
        yt_path = sdk2.parameters.String('YT directory', required=True)
        dir_name = sdk2.parameters.String('Dst directory name', required=True)
        download_from_yt_res_id = sdk2.parameters.LastReleasedResource(
            'download_from_yt binary resource',
            resource_type=AdvMachineDownloadFromYtBin,
            state=(ctr.State.READY, ),
            required=True,
        )

    def get_command_parameters(self):
        raise NotImplementedError("Implement get_command_parameters()")

    def on_execute(self):
        bin_res = sdk2.ResourceData(self.Parameters.download_from_yt_res_id)

        cmd = [
            str(bin_res.path),
            '--yt-path', self.Parameters.yt_path,
            '--dst-path', self.Parameters.dir_name,

            '--yt-proxy', self.Parameters.yt.proxy,
            '--yt-prefix', self.Parameters.yt.prefix,
        ]
        cmd.extend(self.get_command_parameters())
        env = get_yt_config(self.Parameters.yt, self.author)
        secret = sdk2.yav.Secret('sec-01dq7yfgbkh83tx9jk2rsgyggw')
        solomon_token = secret.data()['token']
        env.update({'SOLOMON_TOKEN': solomon_token})

        with process_wrapper(self, logger='download_from_yt') as pl:
            sp.check_call(cmd, stdout=pl.stdout, stderr=pl.stderr, env=env)


class AdvMachineDownloadFromYtTask(AdvMachineDownloadFromYtTaskBase):

    class Parameters(AdvMachineDownloadFromYtTaskBase.Parameters):
        version_controller_path = sdk2.parameters.String('Version controller path', required=False)
        exclude_versioned_resources = sdk2.parameters.Bool('Exclude versioned resources', default=False)
        exclude_unversioned_resources = sdk2.parameters.Bool('Exclude unversioned resources', default=False)
        solomon_project = sdk2.parameters.String('Solomon project', required=False)
        solomon_cluster = sdk2.parameters.String('Solomon cluster', required=False)
        solomon_service = sdk2.parameters.String('Solomon service', required=False)
        old_version_controller_res_id = None

    def get_command_parameters(self):
        cmd = []
        if self.Parameters.version_controller_path:
            cmd.extend(['--version-controller-path', self.Parameters.version_controller_path])

        if self.Parameters.old_version_controller_res_id:
            old_version_controller = sdk2.ResourceData(self.Parameters.old_version_controller_res_id)
            cmd.extend(['--old-version-controller-path', str(old_version_controller.path)])

        if self.Parameters.exclude_versioned_resources:
            cmd.append('--exclude-versioned')

        if self.Parameters.exclude_unversioned_resources:
            cmd.append('--exclude-unversioned')

        if (self.Parameters.solomon_project and self.Parameters.solomon_cluster and self.Parameters.solomon_service):
            cmd.extend(['--solomon-project', self.Parameters.solomon_project])
            cmd.extend(['--solomon-cluster', self.Parameters.solomon_cluster])
            cmd.extend(['--solomon-service', self.Parameters.solomon_service])

        return cmd

    def on_execute(self):
        super(AdvMachineDownloadFromYtTask, self).on_execute()
