# -*- coding: utf-8 -*-

from sandbox import sdk2
import sandbox.common.types.resource as ctr

from sandbox.sdk2.helpers import subprocess as sp

from sandbox.projects.adv_machine.common import process_wrapper, AdvMachineReleaseTask
from sandbox.projects.adv_machine.common.resources import AdvMachineDownloadProtoTableBin


class AdvMachineDownloadOnlineResourceTask(AdvMachineReleaseTask):
    """Creates AdvMachine generic online resource"""

    class Requirements(AdvMachineReleaseTask.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(AdvMachineReleaseTask.Parameters):
        with sdk2.parameters.Group('YT parameters') as yt_block:
            yt_proxy = sdk2.parameters.String('YT proxy', required=True, default='hahn')
            yt_token_vault = sdk2.parameters.String('YT_TOKEN vault name', required=True, default='adv_machine_yt_token')
            yt_table_path = sdk2.parameters.String('YT table', required=True)
            yt_pool = sdk2.parameters.String('YT pool', required=False, default='adv-machine')

        mode = sdk2.parameters.String('download_proto_table mode', required=False)
        columns = sdk2.parameters.List('Columns to extract from YT table', required=False, default=[])
        resource_path = sdk2.parameters.String('Dst resource name', required=True)

        build_online_resource_id = sdk2.parameters.LastReleasedResource(
            'download_proto_table binary resource',
            resource_type=AdvMachineDownloadProtoTableBin,
            state=(ctr.State.READY, ),
            required=True,
        )

    def on_execute(self):
        bin_res = sdk2.ResourceData(self.Parameters.build_online_resource_id)

        cmd = [str(bin_res.path)]

        if self.Parameters.mode:
            cmd += [self.Parameters.mode]

        cmd += [
            '--src-table', self.Parameters.yt_table_path,
            '--output', self.Parameters.resource_path,
            '-s', self.Parameters.yt_proxy
        ]

        for column in self.Parameters.columns:
            cmd += ['-c', column]

        env = {}
        if self.Parameters.yt_token_vault:
            env['YT_TOKEN'] = sdk2.Vault.data(self.Parameters.yt_token_vault)

        if self.Parameters.yt_pool:
            env['YT_POOL'] = self.Parameters.yt_pool

        with process_wrapper(self, logger='download_proto_table') as pl:
            sp.check_call(cmd, stdout=pl.stdout, stderr=pl.stderr, env=env)

    def on_release(self, params):
        super(AdvMachineDownloadOnlineResourceTask, self).on_release(params)
        self.mark_released_resources(params['release_status'], ttl=7)
