from sandbox import sdk2
import sandbox.common.types.resource as ctr

from sandbox.projects import resource_types
from sandbox.sandboxsdk import parameters


class YTParameters(sdk2.Task.Parameters):
    with sdk2.parameters.Group('YT parameters') as yt_block:
        proxy = sdk2.parameters.String('YT_PROXY', required=True, default='hahn')
        prefix = sdk2.parameters.String('YT_PREFIX', required=True, default='//home/advquality/')
        token_vault = sdk2.parameters.String('YT_TOKEN vault name', required=True, default='adv_machine_yt_token')
        pool = sdk2.parameters.String('YT_POOL', required=False)


class YTLocalParameters(YTParameters):
    with YTParameters.yt_block() as yt_block:
        proxy = YTParameters.proxy(default='localhost')
        token_vault = YTParameters.token_vault(required=False, default=None)
        yt_local = sdk2.parameters.Resource(
            'YT local',
            resource_type=resource_types.YT_LOCAL,
            state=(ctr.State.READY,),
            required=True,
        )


RELEASE_PARAMETERS_GROUP_NAME = 'Nanny release parameters'


class DeployAfterRelease(parameters.SandboxBoolParameter):
    name = 'deploy_after_release'
    description = 'Deploy after release automatically'
    group = RELEASE_PARAMETERS_GROUP_NAME
    default_value = True


class DeployTicketIdParameter(parameters.SandboxStringParameter):
    name = 'deploy_ticket_id'
    description = 'Deploy startrek ticket id'
    group = RELEASE_PARAMETERS_GROUP_NAME
