from sandbox import sdk2
from sandbox.projects.common.build.YaPackage import YaPackageResource

adv_machine_subscribers = ['rudolf']

adv_machine_devops = ['rudolf', 'ekondranin', 'dpaveldev', 'jisuto', 'nomapunk', 'irony', 'kirkov-andrey', 'eugeninic', 'xveduk', ]

adv_machine_releasers = adv_machine_devops + [
    'robot-adv-machine', 'robot-am-indexer', 'robot-am-helper',
    'scaiper', 'shevkunov', 'muradmazitov', 'kolyakolya',
    'sameg', 'smurylev', 'zimmaxim', 'goodnight', 'fedorets', 'levsky', 'lirikl31', 'dkochergin', 'david-tyuman',
    'mpdenise', 'bonv',  # market team
]

adv_machine_script_releasers = adv_machine_releasers

adv_machine_data_releasers = adv_machine_releasers + ['sameg', 'apos', 'insight']

solo_creator_releasers = adv_machine_devops + ['robot-adv-machine']


class AdvMachineReleaseResource(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    any_arch = True
    auto_backup = True
    releasers = adv_machine_releasers
    release_subscribers = adv_machine_subscribers

    release_services = []


class AdvMachineYtDataResource(AdvMachineReleaseResource):
    default_path = None
    pass


class AdvMachineQuorumsMachineAmmo(AdvMachineReleaseResource):
    pass


class AdvMachineArcadiaResource(AdvMachineReleaseResource):
    arts = []
    arts_source = []
    arts_union = []

    arcadia_branch = sdk2.parameters.String('arcadia_branch')
    arcadia_revision = sdk2.parameters.String('arcadia_revision')


# AdvMachine binaries

rsya_release_services = [
    'adv-machine-rsya-rmp',
    'adv-machine-rsya-rm-machine',
    'adv-machine-offer-retargeting',
]

apphost_release_services = [
    'adv-machine-rm-apphost',
    'adv-machine-dsa-apphost',
    'adv-machine-search-apphost',
    'adv-machine-all-search-apphost-yp',
]

offline_search_release_services = [
    'adv-machine-bm-main',
    'adv-machine-rm-main',
    'adv-machine-all-search-main',
    'adv-machine-dsa-workers',
    'adv-machine-dsa-daemons',
]

skipper_services = [
    'adv-machine-skipper',
]

other_services = [
]


class AdvMachineConfig(AdvMachineArcadiaResource):
    __description__ = 'AdvMachine configs'
    release_services = apphost_release_services + \
                       offline_search_release_services + \
                       rsya_release_services + \
                       skipper_services + \
                       other_services

    arts_source = [
        'ads/quality/adv_machine/config/'
    ]


class AdvMachineRuntimeBin(AdvMachineArcadiaResource):
    __description__ = 'AdvMachine runtime bin'
    release_services = apphost_release_services + \
                       offline_search_release_services + \
                       rsya_release_services + \
                       other_services
    arts = [
        'ads/quality/adv_machine/runtime/am_runtime',
        'ads/quality/adv_machine/scripts/multihost_prepare/am_multihost_prepare',
        'ads/quality/adv_machine/scripts/download_online_resources/download_online_resources',
        'ads/quality/adv_machine/bin_meta_runtime/am_bin_meta_runtime',
        'ads/quality/adv_machine/quorum_machine_daemon/am_quorum_machine_daemon',
        'ads/quality/adv_machine/quorum_machine_meta/am_quorum_machine_meta',
        'ads/quality/adv_machine/priemka/am_priemka',
        'ads/quality/adv_machine/scripts/fast_index_tools/am_fast_index_tools',
        'ads/quality/adv_machine/aggregator/am_aggregator',
        'ads/quality/adv_machine/viewers/am_viewers',
    ]
    arts_source = [
        'ads/quality/adv_machine/scripts/template.py',
    ]


class AdvMachineIndexerBin(AdvMachineArcadiaResource):
    __description__ = 'AdvMachine indexer bin'
    arts = [
        'ads/quality/adv_machine/mr_index/am_mr_index',
        'ads/quality/adv_machine/scripts/shard_map_from_sandbox/am_shard_map_from_sandbox',
        'ads/quality/adv_machine/scripts/fast_index_tools/am_fast_index_tools',
    ]


class AdvMachineReleaseTools(AdvMachineArcadiaResource):
    __description__ = 'AdvMachine release tools'
    arts = [
        'ads/quality/adv_machine/scripts/release_tools/am_release_tools',
    ]


class AdvMachineIndexerConfig(AdvMachineArcadiaResource):
    __description__ = 'AdvMachine indexer config'
    arts_source = [
        'ads/quality/adv_machine/config/indexer/'
    ]


class AdvMachineCompareIndexBin(AdvMachineArcadiaResource):
    __description__ = 'AdvMachine binaries to compare indices'
    arts = [
        'ads/quality/adv_machine/tools/compare_index_tables',
    ]


class AdvMachineDownloadDataBin(AdvMachineArcadiaResource):
    __description__ = 'AdvMachine binary to download data'
    arts = [
        'ads/quality/adv_machine/scripts/download_data',
    ]


class AdvMachineWorkerTools(AdvMachineArcadiaResource):
    __description__ = 'AdvMachine worker tools'
    arts = [
        'ads/quality/adv_machine/cluster_tools/worker_tools/prepare/am_prepare_worker_shooting',
        'ads/quality/adv_machine/cluster_tools/worker_tools/shoot/am_shoot_worker',
    ]


class AdvMachineRobotResourceBase(AdvMachineArcadiaResource):
    release_services = [
        'adv-machine-robot-cm-hahn',
    ]


class AdvMachineUdf(AdvMachineArcadiaResource):
    pass


class AdvMachineRobotBin(AdvMachineRobotResourceBase):
    __description__ = 'AdvMachine robot bin'
    arts_union = [
        'ads/quality/adv_machine/cm_robot/robot_bins'
    ]


class AdvMachineDssmVersionController(AdvMachineRobotResourceBase):
    __description__ = 'AdvMachine dssm version controller'


class AdvMachineLinearModelsVersionController(AdvMachineRobotResourceBase):
    __description__ = 'AdvMachine linear models version controller'


class AdvMachineExportAngBin(AdvMachineRobotResourceBase):
    __description__ = 'AdvMachine export_ang_to_hahn bin'
    arts = [
        'ads/quality/adv_machine/scripts/export_ang_to_hahn/export_ang_to_hahn',
        'ads/quality/yang_conversion_banners/yang_conversion_banners',
    ]


class AdvMachineDirectQuorumBin(AdvMachineRobotResourceBase):
    __description__ = 'AdvMachine direct_quorum_tool bins'
    arts = [
        'ads/quality/direct_quorum/direct_quorum_tool',
    ]


class AdvMachineRobotScripts(AdvMachineRobotResourceBase):
    __description__ = 'AdvMachine robot scripts'
    arts_union = [
        'ads/quality/adv_machine/cm'
    ]
    arts_source = [
        'ads/quality/adv_machine/cm/tables_tool/tables.json'
    ]


class AdvContentMerger(AdvMachineArcadiaResource):
    __description__ = 'Binaries for adv-content-merger'
    release_services = [
        'adv-content-merger-prod',
    ]
    arts = [
        'ads/quality/kiwi_export/tools/content_filter/adv-content-filter',
        'ads/quality/kiwi_export/tools/content_merger/adv-content-merger',
        'ads/quality/kiwi_export/tools/content_processor/adv-content-processor',
    ]
    arts_source = [
        'ads/quality/kiwi_export/config/banner_content.pb.txt',
        'ads/quality/kiwi_export/cm/cm.sh',
        'ads/quality/kiwi_export/cm/hostlist',
    ]


class AdvMachineEdadealRobotPackage(AdvMachineArcadiaResource):
    __description__ = 'Binaries and scripts for edadeal-machine robot'
    release_services = [
        'adv-machine-edadeal-robot',
    ]
    arts_union = [
        'ads/quality/adv_machine/edadeal/cm_robot/bins',
        'ads/quality/adv_machine/edadeal/cm_robot/scripts'
    ]


class AdvMachineContentMergerPackage(AdvMachineArcadiaResource):
    __description__ = 'Binaries and scripts for adv-machine content merger robot'
    release_services = [
        'adv-content-merger-prod',
        'adv-content-merger-prestable'
    ]
    arts_union = [
        'ads/quality/adv_machine/content_merger/cm_robot/bins',
        'ads/quality/adv_machine/content_merger/cm_robot/scripts'
    ]


class AdvMachineTsarPackage(AdvMachineArcadiaResource):
    __description__ = 'Binaries and scripts for adv-machine tsar robot'
    release_services = [
        'adv-tsar-prod',
        'adv-tsar-prestable'
    ]
    arts_union = [
        'ads/quality/adv_machine/tsar/cm_robot/bins',
        'ads/quality/adv_machine/tsar/cm_robot/scripts'
    ]


class AdvMachineOfferBaseRobotPackage(AdvMachineArcadiaResource):
    __description__ = 'Binaries and scripts for adv-machine offer base robot'
    release_services = [
        'adv-machine-offer-base-robot'
    ]
    arts_union = [
        'ads/quality/adv_machine/offer_base/cm_robot/bins',
        'ads/quality/adv_machine/offer_base/cm_robot/scripts'
    ]


class AdvMachineExpRobotPackage(AdvMachineArcadiaResource):
    __description__ = 'Binaries and scripts for exps robot'
    release_services = [
        'adv-machine-robot-cm-hahn-exp',
    ]
    arts_union = [
        'ads/quality/adv_machine/cm_robot/robot_bins',
    ]


class AdvMachineLmWbcStaticRegular(AdvMachineReleaseResource):
    """program to train static wbc model for advmachine"""

    releasers = adv_machine_script_releasers


class AdvMachineLmConversionRegular(AdvMachineReleaseResource):
    """program to train PrGoodMultiGoal models for advmachine"""

    releasers = adv_machine_script_releasers


class AdvMachineLmWbcRegular(AdvMachineReleaseResource):
    """program to train wbc models for advmachine"""

    releasers = adv_machine_script_releasers


class AdvMachineCmInputTablesSample(AdvMachineReleaseResource):
    """AdvMachine ClusterMaster tables sample"""

    releasers = adv_machine_script_releasers


class AdvMachineSoloCreator(YaPackageResource):
    """SOLO creator package"""
    auto_backup = True
    releasable = True
    calc_md5 = True
    share = True
    releasers = solo_creator_releasers
    release_subscribers = adv_machine_subscribers


class AdvMachineInstancectlUpdater(YaPackageResource):
    """Instancectl updater package"""
    auto_backup = True
    releasable = True
    calc_md5 = True
    share = True
    releasers = solo_creator_releasers
    release_subscribers = adv_machine_subscribers


# AdvMachine data with release services

class AdvMachineDataResourceBase(AdvMachineReleaseResource):
    releasers = adv_machine_data_releasers
    test_attempt_id = sdk2.parameters.String('test_attempt_id')


class AdvMachineFormulas(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine formulas'
    release_services = rsya_release_services + apphost_release_services + other_services


class AdvMachineSkipperFormulas(AdvMachineDataResourceBase):
    __description__ = 'Skipper formulas'
    release_services = skipper_services


class AdvMachineSkipperLinearModels(AdvMachineDataResourceBase):
    __description__ = 'Skipper linear models'
    release_services = skipper_services


class AdvMachineDataLinearModels(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine linear models'
    release_services = rsya_release_services


class AdvMachineDataPoorMansL3(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine bert poor mans l3 layer'
    release_services = apphost_release_services


class AdvMachineDataDssm(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine dssm'
    release_services = rsya_release_services + apphost_release_services + offline_search_release_services


class AdvMachineDataVersionedDssm(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine versioned dssm'
    release_services = rsya_release_services + apphost_release_services + offline_search_release_services


class AdvMachineDataHitModelsDssm(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine dssm for yabs_hit_models service'
    release_services = rsya_release_services + apphost_release_services + offline_search_release_services
    model = sdk2.Attributes.String('Model name', required=True, default="unknown")


class AdvMachineDataSelectTypeJson(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine select_type.json'
    release_services = rsya_release_services + apphost_release_services


class AdvMachineCatResources(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine Cat Machine Resources'
    release_services = rsya_release_services


class AdvMachineIdfs(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine Idfs (deprecated)'
    release_services = rsya_release_services


class AdvMachineCatEngineIdfs(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine Cat Engine Idfs'
    release_services = rsya_release_services


class AdvMachineGamesDict(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine games dict'
    release_services = [
        'adv-machine-games',
    ]


class AdvMachineGoalsDict(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine goals.dict resource'
    release_services = rsya_release_services


class AdvMachinePagesDict(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine pages.dict resource'
    release_services = rsya_release_services


class AdvMachineOfferRetargetingDict(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine offer-retargeting dict'
    release_services = rsya_release_services


class AdvMachineOrganizationsDicts(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine organizations dicts resource'
    release_services = rsya_release_services


class AdvMachineOffersCountersSet(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine counters from OffersDict set'
    release_services = skipper_services


class AdvMachineRetargetingSegmentsSet(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine retargeting segments set'
    release_services = skipper_services


class AdvMachineSelectionRankFormulas(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine selection rank formulas'
    release_services = ['adv-machine-robot-cm-hahn']


class AdvMachineSelectionRankLinearModels(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine selection rank linear models'
    release_services = ['adv-machine-robot-cm-hahn']


class AdvMachineOfferRetargetingCooccurrences(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine cooccurrences for offer retargeting'
    release_services = ['adv-machine-offer-retargeting']


# AdvMachine data without release services


class AdvMachineAmmo(AdvMachineDataResourceBase):
    service_name = sdk2.resource.Attributes.String("Service name")
    pass


class AdvMachineAmmoDaemonHit(AdvMachineDataResourceBase):
    pass


class AdvMachineDataSovetnikDict(AdvMachineReleaseResource):
    pass


class AdvMachineDataMarketModelProfiles(AdvMachineReleaseResource):
    pass


class AdvMachineDataLangDir(AdvMachineReleaseResource):
    arcadia_build_path = 'search/wizard/data/wizard/'


class AdvMachineDataSynnorm(AdvMachineDataResourceBase):
    pass


class AdvMachineDataRequests(AdvMachineReleaseResource):
    pass


class AdvMachineDataOrderMoneyLeftCaesar(AdvMachineDataResourceBase):
    pass


class AdvMachineEntityExtractorData(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine entity extractor data'


# Useful resources

class AdvMachineDownloadProtoTableBin(AdvMachineReleaseResource):
    pass


# Resources for tests

class AdvMachineTestStreamsTable(AdvMachineYtDataResource):
    table_type = sdk2.parameters.String('table_type')


class AdvMachineTestDBRestoreTables(AdvMachineYtDataResource):
    table_type = sdk2.parameters.String('table_type')


class AdvMachinePreIndexTable(AdvMachineYtDataResource):
    pass


class AdvMachineBlackListsTables(AdvMachineYtDataResource):
    default_path = '//home/advquality/adv_machine/orders_black_list'
    pass


class AdvMachinePushClientBin(AdvMachineArcadiaResource):
    pass


class AdvMachineYtLocalLogs(sdk2.Resource):
    releasable = False
    any_arch = True
    auto_backup = True


class AdvMachineRsyaProfilesSample(sdk2.Resource):
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = adv_machine_releasers
    release_subscribers = adv_machine_subscribers


class AdvMachineRsyaRegularLogProfilesSample(AdvMachineRsyaProfilesSample):
    pass


class AdvMachineRsyaHitLogProfilesSample(AdvMachineRsyaProfilesSample):
    pass


class AdvMachineRsyaActionLogProfilesSample(AdvMachineRsyaProfilesSample):
    pass


class AdvMachinePriemkaAmmo(AdvMachineReleaseResource):
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = adv_machine_releasers
    release_subscribers = adv_machine_subscribers


class AdvMachineNannyShardMap(AdvMachineReleaseResource):
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = adv_machine_releasers
    release_subscribers = adv_machine_subscribers


# balancers


class OnlineMerchMachineBalancerSamogonPackage(AdvMachineReleaseResource):
    """online merch machine L7 balancer samogon package"""

    releasers = adv_machine_releasers + ['amitin']
    release_subscribers = adv_machine_subscribers + ['amitin']


class OnlineBeruMachineBalancerSamogonPackage(AdvMachineReleaseResource):
    """online beru machine L7 balancer samogon package"""

    releasers = adv_machine_releasers + ['amitin']
    release_subscribers = adv_machine_subscribers + ['amitin']


# Resourses for nirvana graphs


class AdvMachineFormulasRevision(AdvMachineReleaseResource):
    pass


class AdvMachineExperimentsRevision(AdvMachineReleaseResource):
    pass


class AdvMachinePriemkaSettings(AdvMachineReleaseResource):
    pass


class AdvMachineHostsLists(AdvMachineReleaseResource):
    pass


class AdvMachineDataDMLCFactorizationModels(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine dmlc factirization models'
    release_services = rsya_release_services


class AdvMachineTurboShopId2CounterId(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine TurboShopId2CounterId mappings'
    release_services = other_services


class TurboappDicts(AdvMachineDataResourceBase):
    pass


class TurboappOfferInfos(AdvMachineDataResourceBase):
    pass


class SuperappMakeDictsBin(AdvMachineArcadiaResource):
    __description__ = 'binary to make turboapp dicts'
    arts = [
        'ads/quality/superapp/make_files/superapp_make_dicts',
    ]


class SuperappHttpDirectBin(AdvMachineArcadiaResource):
    __description__ = 'Superapp http direct binary'
    arts = [
        'ads/quality/superapp/http4direct/superapp_http_direct',
    ]


class TsarPageImpMap(AdvMachineDataResourceBase):
    pass


class AdvMachineDump(AdvMachineReleaseResource):
    last_log_date = sdk2.parameters.String('last_log_date')


class AbandonedOffersExpBin(AdvMachineArcadiaResource):
    __description__ = 'binary to make abandoned offers index'
    arts = [
        'ads/quality/adv_machine/experiments/light_offer_index/am_light_offer_index',
    ]


class AbandonedOffersExpDict(AdvMachineDataResourceBase):
    pass


class AdvMachineCurrencyDicts(AdvMachineDataResourceBase):
    pass


class AdvMachineORMBase(AdvMachineDataResourceBase):
    __description__ = 'AdvMachine onsite recs index (ADVMACHINE-1916)'
    release_services = ['adv-machine-goods-recom']


class AdvMachineBannerTsarDumpsList(AdvMachineReleaseResource):
    """Resource with folders of distinct banner torch tsar models for adv_machine"""
    released = "stable"


class AdvMachineUserTsarDumpsList(AdvMachineReleaseResource):
    """Resource with folders of distinct user torch tsar models for adv_machine"""
    released = "stable"


class AdvMachineExternalNeuralNetworks(AdvMachineReleaseResource):
    """Resource with neural networks from CV"""
    released = "stable"


class BlSrAlgoSwitcherResource(AdvMachineDataResourceBase):
    """Resource for ads/quality/adv_machine/experiments/bl_sr"""
    pass


class BlGenModels(AdvMachineDataResourceBase):
    """Resource containing directory "data" with bl_gen AlgoSwitchers (ads/quality/adv_machine/experiments/bl_sr)"""
    pass
