# -*- coding: utf-8 -*-

import os
import logging

from sandbox import sdk2

from sandbox.projects.common.yt_runner import YTRunner, YTPackage


class YtLocal:

    def __init__(self, yt_local_res, ncpu, memory, tmpfs_path=None, node_chunk_store_quota=None):
        self.yt_local_res = yt_local_res
        self.config = {'ncpu': ncpu, 'physmem': memory}
        self.tmpfs_path = tmpfs_path
        self.node_chunk_store_quota = node_chunk_store_quota
        self.yt_runner = None
        self.yt_log_path = 'yt-local'

    def start(self):
        logging.info('YtLocal starting')

        yt_local = sdk2.ResourceData(self.yt_local_res)
        yt_package = YTPackage(tar_path=str(yt_local.path), root_dir=os.getcwd())
        yt_package.install()

        logging.info('YtPackage installed')

        self.yt_runner = YTRunner(
            yt_package,
            self.config,
            log_dir=self.yt_log_path,
            tmpfs=self.tmpfs_path,
            forbid_chunk_storage_in_tmpfs=True,
            node_chunk_store_quota=self.node_chunk_store_quota,
        )
        self.yt_runner.start()

        logging.info('YtLocal started')

    def stop(self):
        logging.info('YtLocal stopping')

        self.yt_runner.teardown_server()

        logging.info('YtLocal stopped')

    def __enter__(self):
        self.start()
        return self

    def __exit__(self, type, value, traceback):
        self.stop()
