# -*- coding: utf-8 -*-

import os
import logging

from os.path import join as pj

import sandbox.common.types.resource as ctr
from sandbox import sdk2

from sandbox.sdk2.helpers import subprocess as sp

from sandbox.projects.adv_machine.common import process_wrapper
from sandbox.projects.adv_machine.common import AdvMachineReleaseTask
from sandbox.projects.adv_machine.common.parameters import YTParameters
from sandbox.projects.adv_machine.common.resources import AbandonedOffersExpBin, AbandonedOffersExpDict
from sandbox.projects.adv_machine.common.yt_params import get_yt_config


logger = logging.getLogger(__name__)


class MakeAbandonedOffersExpDict(AdvMachineReleaseTask):

    """Create resources"""

    class Requirements(AdvMachineReleaseTask.Requirements):
        ram = 100 * 1024
        disk_space = 20 * 1024

    class Parameters(AdvMachineReleaseTask.Parameters):
        yt = YTParameters
        make_bin_res_id = sdk2.parameters.LastReleasedResource(
            'abandoned_offers_exp binary resource',
            resource_type=AbandonedOffersExpBin,
            state=(ctr.State.READY, ),
            required=True,
        )

    def on_execute(self):
        bin_res = sdk2.ResourceData(self.Parameters.make_bin_res_id)
        target_dir = "ao_dict"
        os.mkdir(target_dir)

        path = str(bin_res.path)
        postfix = "am_light_offer_index"
        if not path.endswith(postfix):
            path = pj(path, postfix)

        cmd = [
            path, 'build-light-offers-index-from-mr-profiles',
            '-o', target_dir + "/index.bin",
            '--server', self.Parameters.yt.proxy,
            '--vvv'
        ]

        env = get_yt_config(self.Parameters.yt, self.author)

        with process_wrapper(self, logger='am_light_offer_index') as pl:
            sp.check_call(cmd, stdout=pl.stdout, stderr=pl.stderr, env=env)

        AbandonedOffersExpDict(self, 'AdvMachine abandoned offers dict: {}'.format(self.Parameters.description), 'ao_dict')

        super(MakeAbandonedOffersExpDict, self).on_execute()
