# -*- coding: utf-8 -*-

import logging

from sandbox.projects.adv_machine.common import AdvMachineDownloadFromYtTask
from sandbox.projects.adv_machine.common.resources import AdvMachineAmmo


logger = logging.getLogger(__name__)


class MakeAdvMachineAmmo(AdvMachineDownloadFromYtTask):

    """Creates a single ammo file resource"""

    class Requirements(AdvMachineDownloadFromYtTask.Requirements):
        pass

    class Parameters(AdvMachineDownloadFromYtTask.Parameters):
        yt_path = AdvMachineDownloadFromYtTask.Parameters.yt_path(default='adv_machine/priemka/aura/ammo', description='Change aura to required service')
        dir_name = AdvMachineDownloadFromYtTask.Parameters.dir_name(default='ammo')

    def on_execute(self):
        AdvMachineAmmo(self, 'AdvMachineAmmo: {}'.format(self.Parameters.description), self.Parameters.dir_name)
        super(MakeAdvMachineAmmo, self).on_execute()
