# -*- coding: utf-8 -*-

import os
import logging

from sandbox import common, sdk2

from sandbox.projects.adv_machine.common import AdvMachineDownloadFromYtTask
from sandbox.projects.adv_machine.common.resources import AdvMachineFormulas


logger = logging.getLogger(__name__)


class MakeAdvMachineFormulas(AdvMachineDownloadFromYtTask):

    """Create adv machine formulas resources"""

    class Requirements(AdvMachineDownloadFromYtTask.Requirements):
        pass

    class Parameters(AdvMachineDownloadFromYtTask.Parameters):
        yt_path = AdvMachineDownloadFromYtTask.Parameters.yt_path(default='adv_machine/formulas')
        dir_name = AdvMachineDownloadFromYtTask.Parameters.dir_name(default='formulas')
        release_services = AdvMachineDownloadFromYtTask.Parameters.release_services(choices=[(s, s) for s in AdvMachineFormulas.release_services])
        formulas = sdk2.parameters.ParentResource('Formulas resource', required=False)

    def on_execute(self):
        if not self.Parameters.formulas:
            AdvMachineFormulas(self, 'AdvMachine formulas: {}'.format(self.Parameters.description), self.Parameters.dir_name)
        os.mkdir(str(self.Parameters.dir_name))
        super(MakeAdvMachineFormulas, self).on_execute()

    def _get_st_message(self, resources, release_services):
        return 'Готовы новые формулы. Скоро будут обновлены на {}. \nАвтор кто:{}. \nТаск {}'.format(
            ', '.join(release_services),
            self.author,
            common.utils.get_task_link(self.id),
        )

    def _get_telegram_message(self, params, resources, release_services):
        return '{} чух-чух на {}. Покатил {} потому что {}. Таск {}'.format(
            ', '.join([str(r.type) for r in resources]),
            ', '.join(release_services),
            params['releaser'],
            params['release_comments'] or self.Parameters.description,
            common.utils.get_task_link(self.id),
        )
