# -*- coding: utf-8 -*-

from sandbox import sdk2
import sandbox.projects.common.build.parameters as build_params
from sandbox.sandboxsdk import svn

from sandbox.projects.adv_machine.common.resources import AdvMachineFormulasRevision


class MakeAdvMachineFormulasRevision(sdk2.Task):

    """Create adv machine formulas revision resource"""

    class Requirements(sdk2.Task.Requirements):
        disk_space = 1024

    class Parameters(sdk2.Task.Parameters):
        description = 'Update formulas revision'
        checkout_arcadia_from_url = build_params.ArcadiaUrl()

    def on_execute(self):
        info = svn.Arcadia.info(self.Parameters.checkout_arcadia_from_url)
        revision = info['commit_revision']
        path = 'revision.txt'
        with open(path, 'w') as f:
            f.write('{}\n'.format(revision))

        AdvMachineFormulasRevision(self, 'AdvMachine formulas revision: {}'.format(revision), path)
