# -*- coding: utf-8 -*-

from sandbox import sdk2
import requests
import json
from urlparse import urljoin
from sandbox.projects.common.nanny import nanny
import sys

from sandbox.projects.adv_machine.common.resources import AdvMachineHostsLists

NANNY_URL = 'http://nanny.yandex-team.ru/'
GENCFG_URL = 'https://api.gencfg.yandex-team.ru/'
SERVICE = '/advquality/'


class MakeAdvMachineHostsLists(nanny.ReleaseToNannyTask2, sdk2.Task):

    """Create adv machine hosts lists resource"""

    class Requirements(sdk2.Task.Requirements):
        disk_space = 1024

    class Parameters(sdk2.Task.Parameters):
        description = 'Update hosts lists'
        partial = sdk2.parameters.Bool('Get partial list')

    def on_execute(self):
        session = requests.Session()
        session.headers['Authorization'] = 'OAuth {}'.format(sdk2.Vault.data('ADV_MACHINE', 'adv_machine_nanny_token'))
        session.headers['Content-Type'] = 'application/json'

        gencfgSession = requests.Session()

        services = session.get(urljoin(NANNY_URL, 'v2/services/?category={}'.format(SERVICE)))
        result = {}
        group2power = {}
        for service in services.json()['result']:
            serviceId = service['_id']
            print >> sys.stderr, 'Requesting service {}'.format(serviceId)
            instances = session.get(urljoin(NANNY_URL, 'v2/services/{}/current_state/instances/{}'.format(serviceId, 'partial/' if self.Parameters.partial else '')))
            result[serviceId] = []
            for instance in instances.json().get('instancesPart' if self.Parameters.partial else 'result', []):
                prefix = 'a_topology_group-'
                groups = [x[len(prefix):] for x in instance['itags'] if x.startswith(prefix)]
                group = None
                power = None
                if len(groups) == 1:
                    group = groups[0]
                    if group not in group2power:
                        print >> sys.stderr, 'Requesting card for {}'.format(group)
                        card = gencfgSession.get(urljoin(GENCFG_URL, 'trunk/groups/{}/card'.format(group)))
                        group2power[group] = card.json()['reqs']['shards']['min_power']
                    power = group2power[group]
                port = instance['port']
                host = instance['container_hostname'] if instance['network_settings'] == 'MTN_ENABLED' else instance['hostname']
                result[serviceId].append({'group': group, 'port': port, 'host': host, 'power': power})

        path = 'hosts_lists.json'
        with open(path, 'w') as f:
            json.dump(result, f, indent=4)

        AdvMachineHostsLists(self, 'AdvMachine hosts lists', path)
