# -*- coding: utf-8 -*-

import os
import logging

from sandbox import common

from sandbox.projects.adv_machine.common import AdvMachineDownloadFromYtTask
from sandbox.projects.adv_machine.common.resources import AdvMachineIdfs


logger = logging.getLogger(__name__)


class MakeAdvMachineIdfs(AdvMachineDownloadFromYtTask):

    """Create adv machine cat machine idfs"""

    class Requirements(AdvMachineDownloadFromYtTask.Requirements):
        pass

    class Parameters(AdvMachineDownloadFromYtTask.Parameters):
        yt_path = AdvMachineDownloadFromYtTask.Parameters.yt_path(default='adv_machine/cat_machine/idfs')
        dir_name = AdvMachineDownloadFromYtTask.Parameters.dir_name(default='idfs')
        release_services = AdvMachineDownloadFromYtTask.Parameters.release_services(choices=[(s, s) for s in AdvMachineIdfs.release_services])

    def on_execute(self):
        os.mkdir(self.Parameters.dir_name)
        AdvMachineIdfs(self, 'AdvMachine cat machine idfs: {}'.format(self.Parameters.description), self.Parameters.dir_name)
        super(MakeAdvMachineIdfs, self).on_execute()

    def _get_st_message(self, resources, release_services):
        return 'Cat machine idfs are ready. Will be updated soon on {}. \nAuthor: {}. \nTask: {}'.format(
            ', '.join(release_services),
            self.author,
            common.utils.get_task_link(self.id),
        )

    def _get_telegram_message(self, params, resources, release_services):
        return '{} is going to {}. Releaser: {}.  Comments: {}. Task: {}'.format(
            ', '.join([str(r.type) for r in resources]),
            ', '.join(release_services),
            params['releaser'],
            params['release_comments'] or self.Parameters.description,
            common.utils.get_task_link(self.id),
        )
