# -*- coding: utf-8 -*-

import os
import logging

from sandbox import common, sdk2
import sandbox.common.types.resource as ctr

from sandbox.projects.adv_machine.common import AdvMachineDownloadFromYtTask
from sandbox.projects.adv_machine.common.resources import AdvMachineDataLinearModels, AdvMachineLinearModelsVersionController


logger = logging.getLogger(__name__)


class MakeAdvMachineLinearModels(AdvMachineDownloadFromYtTask):

    """Create adv machine linear models resources"""

    class Requirements(AdvMachineDownloadFromYtTask.Requirements):
        pass

    class Parameters(AdvMachineDownloadFromYtTask.Parameters):
        yt_path = AdvMachineDownloadFromYtTask.Parameters.yt_path(default='adv_machine/linear_models/stable/models')
        dir_name = AdvMachineDownloadFromYtTask.Parameters.dir_name(default='lm')
        version_controller_path = AdvMachineDownloadFromYtTask.Parameters.version_controller_path(default='lm_version_controller.json')
        release_services = AdvMachineDownloadFromYtTask.Parameters.release_services(choices=[(s, s) for s in AdvMachineDataLinearModels.release_services])

        solomon_project = AdvMachineDownloadFromYtTask.Parameters.solomon_project(default='adv_machine')
        solomon_cluster = AdvMachineDownloadFromYtTask.Parameters.solomon_cluster(default='linear_model_learn')
        solomon_service = AdvMachineDownloadFromYtTask.Parameters.solomon_service(default='main_robot')

        old_version_controller_res_id = sdk2.parameters.LastReleasedResource(
            'old version controller resource',
            resource_type=AdvMachineLinearModelsVersionController,
            state=(ctr.State.READY, ),
            required=False
        )

    def on_execute(self):
        os.mkdir(self.Parameters.dir_name)
        AdvMachineDataLinearModels(self, 'AdvMachine linear models: {}'.format(self.Parameters.description), self.Parameters.dir_name)
        AdvMachineLinearModelsVersionController(self, 'AdvMachineVersionController linear models: {}'.format(self.Parameters.description), self.Parameters.version_controller_path)
        super(MakeAdvMachineLinearModels, self).on_execute()

    def _get_st_message(self, resources, release_services):
        return 'Готовы новые линейные модели. Скоро будут обновлены на {}. \nАвтор кто:{}. \nТаск {}'.format(
            ', '.join(release_services),
            self.author,
            common.utils.get_task_link(self.id),
        )

    def _get_telegram_message(self, params, resources, release_services):
        return '{} чух-чух на {}. Покатил {} потому что {}. Таск {}'.format(
            ', '.join([str(r.type) for r in resources]),
            ', '.join(release_services),
            params['releaser'],
            params['release_comments'] or self.Parameters.description,
            common.utils.get_task_link(self.id),
        )
