# -*- coding: utf-8 -*-

import os
import logging

from sandbox import common

from sandbox.projects.adv_machine.common import AdvMachineDownloadFromYtTask
from sandbox.projects.adv_machine.common.resources import AdvMachineOfferRetargetingCooccurrences


logger = logging.getLogger(__name__)


class MakeAdvMachineOfferRetargetingCooccurrences(AdvMachineDownloadFromYtTask):

    """Create adv machine linear models resources"""

    class Requirements(AdvMachineDownloadFromYtTask.Requirements):
        pass

    class Parameters(AdvMachineDownloadFromYtTask.Parameters):
        folder_name = 'cooccurrence_offer_retargeting_bins'
        yt_path = AdvMachineDownloadFromYtTask.Parameters.yt_path(default='adv_machine/' + folder_name)
        dir_name = AdvMachineDownloadFromYtTask.Parameters.dir_name(default=folder_name)
        release_services = AdvMachineDownloadFromYtTask.Parameters.release_services(choices=[
            (s, s) for s in AdvMachineOfferRetargetingCooccurrences.release_services
        ])

    def on_execute(self):
        os.mkdir(self.Parameters.dir_name)
        description = 'AdvMachine offer retargeting cooccurrences: {}'.format(self.Parameters.description)
        AdvMachineOfferRetargetingCooccurrences(self, description, self.Parameters.dir_name)
        super(MakeAdvMachineOfferRetargetingCooccurrences, self).on_execute()

    def _get_st_message(self, resources, release_services):
        return (
            'Готовы новые offer2offer рекомендации для offer retargeting. '
            + 'Скоро будут обновлены на {}. \nАвтор:{}. \nТаск {}'
        ).format(
            ', '.join(release_services),
            self.author,
            common.utils.get_task_link(self.id),
        )

    def _get_telegram_message(self, params, resources, release_services):
        return '{} чух-чух на {}. Покатил {} потому что {}. Таск {}'.format(
            ', '.join([str(r.type) for r in resources]),
            ', '.join(release_services),
            params['releaser'],
            params['release_comments'] or self.Parameters.description,
            common.utils.get_task_link(self.id),
        )
