# -*- coding: utf-8 -*-

import os
import logging

from sandbox import common

from sandbox.projects.adv_machine.common import AdvMachineDownloadFromYtTask
from sandbox.projects.adv_machine.common.resources import AdvMachineOffersCountersSet


logger = logging.getLogger(__name__)


class MakeAdvMachineOffersCountersSet(AdvMachineDownloadFromYtTask):

    """Create adv machine offers-counters-set resources"""

    class Requirements(AdvMachineDownloadFromYtTask.Requirements):
        pass

    class Parameters(AdvMachineDownloadFromYtTask.Parameters):
        folder_name = 'offers_counters_set'
        yt_path = AdvMachineDownloadFromYtTask.Parameters.yt_path(default='adv_machine/' + folder_name)
        dir_name = AdvMachineDownloadFromYtTask.Parameters.dir_name(default=folder_name)
        release_services = AdvMachineDownloadFromYtTask.Parameters.release_services(choices=[
            (s, s) for s in AdvMachineOffersCountersSet.release_services
        ])

    def on_execute(self):
        os.mkdir(self.Parameters.dir_name)
        AdvMachineOffersCountersSet(self, 'AdvMachine offers counters set: {}'.format(self.Parameters.description), self.Parameters.dir_name)
        super(MakeAdvMachineOffersCountersSet, self).on_execute()

    def _get_st_message(self, resources, release_services):
        return 'Готовы новые списки counter\'ов из OffersDict. Скоро будут обновлены на {}. \nАвтор кто:{}. \nТаск {}'.format(
            ', '.join(release_services),
            self.author,
            common.utils.get_task_link(self.id),
        )

    def _get_telegram_message(self, params, resources, release_services):
        return '{} чух-чух-чух-чух на {}. Покатил {} потому что {}. Таск {}'.format(
            ', '.join([str(r.type) for r in resources]),
            ', '.join(release_services),
            params['releaser'],
            params['release_comments'] or self.Parameters.description,
            common.utils.get_task_link(self.id),
        )
